<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreexistingConditions StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a description of the traveler's pre-existing conditions, the diagnosis date of the condition, and the date of last treatment.
 * @subpackage Structs
 */
class PreexistingConditions extends AbstractStructBase
{
    /**
     * The PreexistingCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PreexistingCondition[]
     */
    public $PreexistingCondition;
    /**
     * Constructor method for PreexistingConditions
     * @uses PreexistingConditions::setPreexistingCondition()
     * @param \StructType\PreexistingCondition[] $preexistingCondition
     */
    public function __construct(array $preexistingCondition = array())
    {
        $this
            ->setPreexistingCondition($preexistingCondition);
    }
    /**
     * Get PreexistingCondition value
     * @return \StructType\PreexistingCondition[]|null
     */
    public function getPreexistingCondition()
    {
        return $this->PreexistingCondition;
    }
    /**
     * This method is responsible for validating the values passed to the setPreexistingCondition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreexistingCondition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreexistingConditionForArrayConstraintsFromSetPreexistingCondition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $preexistingConditionsPreexistingConditionItem) {
            // validation for constraint: itemType
            if (!$preexistingConditionsPreexistingConditionItem instanceof \StructType\PreexistingCondition) {
                $invalidValues[] = is_object($preexistingConditionsPreexistingConditionItem) ? get_class($preexistingConditionsPreexistingConditionItem) : sprintf('%s(%s)', gettype($preexistingConditionsPreexistingConditionItem), var_export($preexistingConditionsPreexistingConditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PreexistingCondition property can only contain items of type \StructType\PreexistingCondition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PreexistingCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\PreexistingCondition[] $preexistingCondition
     * @return \StructType\PreexistingConditions
     */
    public function setPreexistingCondition(array $preexistingCondition = array())
    {
        // validation for constraint: array
        if ('' !== ($preexistingConditionArrayErrorMessage = self::validatePreexistingConditionForArrayConstraintsFromSetPreexistingCondition($preexistingCondition))) {
            throw new \InvalidArgumentException($preexistingConditionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($preexistingCondition) && count($preexistingCondition) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($preexistingCondition)), __LINE__);
        }
        $this->PreexistingCondition = $preexistingCondition;
        return $this;
    }
    /**
     * Add item to PreexistingCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\PreexistingCondition $item
     * @return \StructType\PreexistingConditions
     */
    public function addToPreexistingCondition(\StructType\PreexistingCondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PreexistingCondition) {
            throw new \InvalidArgumentException(sprintf('The PreexistingCondition property can only contain items of type \StructType\PreexistingCondition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PreexistingCondition) && count($this->PreexistingCondition) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PreexistingCondition)), __LINE__);
        }
        $this->PreexistingCondition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreexistingConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
