<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Basic property policy information.
 * @subpackage Structs
 */
class PolicyInfo extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Provides additional information regarding policy information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * The CheckInTime
     * Meta information extracted from the WSDL
     * - documentation: The usual check-in time for the hotel.
     * - use: optional
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * Meta information extracted from the WSDL
     * - documentation: The usual check-out time for the hotel.
     * - use: optional
     * @var string
     */
    public $CheckOutTime;
    /**
     * The MinGuestAge
     * Meta information extracted from the WSDL
     * - documentation: The minimum guest age allowed for a guest at the hotel facility.
     * - use: optional
     * @var int
     */
    public $MinGuestAge;
    /**
     * The MinRecommendedGuestAge
     * Meta information extracted from the WSDL
     * - documentation: The minimum age recommended as a policy guideline for a guest at the hotel facility.
     * - use: optional
     * @var int
     */
    public $MinRecommendedGuestAge;
    /**
     * The UsualStayFreeCutoffAge
     * Meta information extracted from the WSDL
     * - documentation: The usual age limit at which a child can stay free with an adult at the hotel facility. If this value is not set, then there is no cutoff limit.
     * - use: optional
     * @var int
     */
    public $UsualStayFreeCutoffAge;
    /**
     * The UsualStayFreeChildPerAdult
     * Meta information extracted from the WSDL
     * - documentation: The usual number of children meeting the UsualStayFreeCutoffAge allowed to stay free with an adult at the hotel. If this value is not set, then there is no cutoff limit.
     * - use: optional
     * @var int
     */
    public $UsualStayFreeChildPerAdult;
    /**
     * The TotalGuestCount
     * Meta information extracted from the WSDL
     * - documentation: The total guest count allowed in a room at the hotel.
     * - use: optional
     * @var int
     */
    public $TotalGuestCount;
    /**
     * The DefaultTaxServiceInclusive
     * Meta information extracted from the WSDL
     * - documentation: Defines whether tax and service charge are included, by default, with this hotel's rates.
     * - use: optional
     * @var bool
     */
    public $DefaultTaxServiceInclusive;
    /**
     * The KidsStayFree
     * Meta information extracted from the WSDL
     * - documentation: If true there is no charge for children.
     * - use: optional
     * @var bool
     */
    public $KidsStayFree;
    /**
     * The MaxChildAge
     * Meta information extracted from the WSDL
     * - documentation: The maximum age for a child price.
     * - use: optional
     * @var int
     */
    public $MaxChildAge;
    /**
     * The InternetGuaranteeRequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a guarantee is required for an Internet booking. When false, a guarantee is not required for an Internet booking.
     * - use: optional
     * @var bool
     */
    public $InternetGuaranteeRequiredInd;
    /**
     * The AcceptedGuestType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AcceptedGuestType;
    /**
     * The RoomGuaranteeLateArrvInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the hotel guarantees the room for late arrival.
     * - use: optional
     * @var bool
     */
    public $RoomGuaranteeLateArrvInd;
    /**
     * Constructor method for PolicyInfo
     * @uses PolicyInfo::setDescription()
     * @uses PolicyInfo::setCheckInTime()
     * @uses PolicyInfo::setCheckOutTime()
     * @uses PolicyInfo::setMinGuestAge()
     * @uses PolicyInfo::setMinRecommendedGuestAge()
     * @uses PolicyInfo::setUsualStayFreeCutoffAge()
     * @uses PolicyInfo::setUsualStayFreeChildPerAdult()
     * @uses PolicyInfo::setTotalGuestCount()
     * @uses PolicyInfo::setDefaultTaxServiceInclusive()
     * @uses PolicyInfo::setKidsStayFree()
     * @uses PolicyInfo::setMaxChildAge()
     * @uses PolicyInfo::setInternetGuaranteeRequiredInd()
     * @uses PolicyInfo::setAcceptedGuestType()
     * @uses PolicyInfo::setRoomGuaranteeLateArrvInd()
     * @param mixed $description
     * @param string $checkInTime
     * @param string $checkOutTime
     * @param int $minGuestAge
     * @param int $minRecommendedGuestAge
     * @param int $usualStayFreeCutoffAge
     * @param int $usualStayFreeChildPerAdult
     * @param int $totalGuestCount
     * @param bool $defaultTaxServiceInclusive
     * @param bool $kidsStayFree
     * @param int $maxChildAge
     * @param bool $internetGuaranteeRequiredInd
     * @param string $acceptedGuestType
     * @param bool $roomGuaranteeLateArrvInd
     */
    public function __construct($description = null, $checkInTime = null, $checkOutTime = null, $minGuestAge = null, $minRecommendedGuestAge = null, $usualStayFreeCutoffAge = null, $usualStayFreeChildPerAdult = null, $totalGuestCount = null, $defaultTaxServiceInclusive = null, $kidsStayFree = null, $maxChildAge = null, $internetGuaranteeRequiredInd = null, $acceptedGuestType = null, $roomGuaranteeLateArrvInd = null)
    {
        $this
            ->setDescription($description)
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime)
            ->setMinGuestAge($minGuestAge)
            ->setMinRecommendedGuestAge($minRecommendedGuestAge)
            ->setUsualStayFreeCutoffAge($usualStayFreeCutoffAge)
            ->setUsualStayFreeChildPerAdult($usualStayFreeChildPerAdult)
            ->setTotalGuestCount($totalGuestCount)
            ->setDefaultTaxServiceInclusive($defaultTaxServiceInclusive)
            ->setKidsStayFree($kidsStayFree)
            ->setMaxChildAge($maxChildAge)
            ->setInternetGuaranteeRequiredInd($internetGuaranteeRequiredInd)
            ->setAcceptedGuestType($acceptedGuestType)
            ->setRoomGuaranteeLateArrvInd($roomGuaranteeLateArrvInd);
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\PolicyInfo
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \StructType\PolicyInfo
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \StructType\PolicyInfo
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
    /**
     * Get MinGuestAge value
     * @return int|null
     */
    public function getMinGuestAge()
    {
        return $this->MinGuestAge;
    }
    /**
     * Set MinGuestAge value
     * @param int $minGuestAge
     * @return \StructType\PolicyInfo
     */
    public function setMinGuestAge($minGuestAge = null)
    {
        // validation for constraint: int
        if (!is_null($minGuestAge) && !(is_int($minGuestAge) || ctype_digit($minGuestAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minGuestAge, true), gettype($minGuestAge)), __LINE__);
        }
        $this->MinGuestAge = $minGuestAge;
        return $this;
    }
    /**
     * Get MinRecommendedGuestAge value
     * @return int|null
     */
    public function getMinRecommendedGuestAge()
    {
        return $this->MinRecommendedGuestAge;
    }
    /**
     * Set MinRecommendedGuestAge value
     * @param int $minRecommendedGuestAge
     * @return \StructType\PolicyInfo
     */
    public function setMinRecommendedGuestAge($minRecommendedGuestAge = null)
    {
        // validation for constraint: int
        if (!is_null($minRecommendedGuestAge) && !(is_int($minRecommendedGuestAge) || ctype_digit($minRecommendedGuestAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minRecommendedGuestAge, true), gettype($minRecommendedGuestAge)), __LINE__);
        }
        $this->MinRecommendedGuestAge = $minRecommendedGuestAge;
        return $this;
    }
    /**
     * Get UsualStayFreeCutoffAge value
     * @return int|null
     */
    public function getUsualStayFreeCutoffAge()
    {
        return $this->UsualStayFreeCutoffAge;
    }
    /**
     * Set UsualStayFreeCutoffAge value
     * @param int $usualStayFreeCutoffAge
     * @return \StructType\PolicyInfo
     */
    public function setUsualStayFreeCutoffAge($usualStayFreeCutoffAge = null)
    {
        // validation for constraint: int
        if (!is_null($usualStayFreeCutoffAge) && !(is_int($usualStayFreeCutoffAge) || ctype_digit($usualStayFreeCutoffAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usualStayFreeCutoffAge, true), gettype($usualStayFreeCutoffAge)), __LINE__);
        }
        $this->UsualStayFreeCutoffAge = $usualStayFreeCutoffAge;
        return $this;
    }
    /**
     * Get UsualStayFreeChildPerAdult value
     * @return int|null
     */
    public function getUsualStayFreeChildPerAdult()
    {
        return $this->UsualStayFreeChildPerAdult;
    }
    /**
     * Set UsualStayFreeChildPerAdult value
     * @param int $usualStayFreeChildPerAdult
     * @return \StructType\PolicyInfo
     */
    public function setUsualStayFreeChildPerAdult($usualStayFreeChildPerAdult = null)
    {
        // validation for constraint: int
        if (!is_null($usualStayFreeChildPerAdult) && !(is_int($usualStayFreeChildPerAdult) || ctype_digit($usualStayFreeChildPerAdult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usualStayFreeChildPerAdult, true), gettype($usualStayFreeChildPerAdult)), __LINE__);
        }
        $this->UsualStayFreeChildPerAdult = $usualStayFreeChildPerAdult;
        return $this;
    }
    /**
     * Get TotalGuestCount value
     * @return int|null
     */
    public function getTotalGuestCount()
    {
        return $this->TotalGuestCount;
    }
    /**
     * Set TotalGuestCount value
     * @param int $totalGuestCount
     * @return \StructType\PolicyInfo
     */
    public function setTotalGuestCount($totalGuestCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalGuestCount) && !(is_int($totalGuestCount) || ctype_digit($totalGuestCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalGuestCount, true), gettype($totalGuestCount)), __LINE__);
        }
        $this->TotalGuestCount = $totalGuestCount;
        return $this;
    }
    /**
     * Get DefaultTaxServiceInclusive value
     * @return bool|null
     */
    public function getDefaultTaxServiceInclusive()
    {
        return $this->DefaultTaxServiceInclusive;
    }
    /**
     * Set DefaultTaxServiceInclusive value
     * @param bool $defaultTaxServiceInclusive
     * @return \StructType\PolicyInfo
     */
    public function setDefaultTaxServiceInclusive($defaultTaxServiceInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultTaxServiceInclusive) && !is_bool($defaultTaxServiceInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultTaxServiceInclusive, true), gettype($defaultTaxServiceInclusive)), __LINE__);
        }
        $this->DefaultTaxServiceInclusive = $defaultTaxServiceInclusive;
        return $this;
    }
    /**
     * Get KidsStayFree value
     * @return bool|null
     */
    public function getKidsStayFree()
    {
        return $this->KidsStayFree;
    }
    /**
     * Set KidsStayFree value
     * @param bool $kidsStayFree
     * @return \StructType\PolicyInfo
     */
    public function setKidsStayFree($kidsStayFree = null)
    {
        // validation for constraint: boolean
        if (!is_null($kidsStayFree) && !is_bool($kidsStayFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kidsStayFree, true), gettype($kidsStayFree)), __LINE__);
        }
        $this->KidsStayFree = $kidsStayFree;
        return $this;
    }
    /**
     * Get MaxChildAge value
     * @return int|null
     */
    public function getMaxChildAge()
    {
        return $this->MaxChildAge;
    }
    /**
     * Set MaxChildAge value
     * @param int $maxChildAge
     * @return \StructType\PolicyInfo
     */
    public function setMaxChildAge($maxChildAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildAge) && !(is_int($maxChildAge) || ctype_digit($maxChildAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChildAge, true), gettype($maxChildAge)), __LINE__);
        }
        $this->MaxChildAge = $maxChildAge;
        return $this;
    }
    /**
     * Get InternetGuaranteeRequiredInd value
     * @return bool|null
     */
    public function getInternetGuaranteeRequiredInd()
    {
        return $this->InternetGuaranteeRequiredInd;
    }
    /**
     * Set InternetGuaranteeRequiredInd value
     * @param bool $internetGuaranteeRequiredInd
     * @return \StructType\PolicyInfo
     */
    public function setInternetGuaranteeRequiredInd($internetGuaranteeRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($internetGuaranteeRequiredInd) && !is_bool($internetGuaranteeRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($internetGuaranteeRequiredInd, true), gettype($internetGuaranteeRequiredInd)), __LINE__);
        }
        $this->InternetGuaranteeRequiredInd = $internetGuaranteeRequiredInd;
        return $this;
    }
    /**
     * Get AcceptedGuestType value
     * @return string|null
     */
    public function getAcceptedGuestType()
    {
        return $this->AcceptedGuestType;
    }
    /**
     * Set AcceptedGuestType value
     * @param string $acceptedGuestType
     * @return \StructType\PolicyInfo
     */
    public function setAcceptedGuestType($acceptedGuestType = null)
    {
        // validation for constraint: string
        if (!is_null($acceptedGuestType) && !is_string($acceptedGuestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptedGuestType, true), gettype($acceptedGuestType)), __LINE__);
        }
        $this->AcceptedGuestType = $acceptedGuestType;
        return $this;
    }
    /**
     * Get RoomGuaranteeLateArrvInd value
     * @return bool|null
     */
    public function getRoomGuaranteeLateArrvInd()
    {
        return $this->RoomGuaranteeLateArrvInd;
    }
    /**
     * Set RoomGuaranteeLateArrvInd value
     * @param bool $roomGuaranteeLateArrvInd
     * @return \StructType\PolicyInfo
     */
    public function setRoomGuaranteeLateArrvInd($roomGuaranteeLateArrvInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomGuaranteeLateArrvInd) && !is_bool($roomGuaranteeLateArrvInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomGuaranteeLateArrvInd, true), gettype($roomGuaranteeLateArrvInd)), __LINE__);
        }
        $this->RoomGuaranteeLateArrvInd = $roomGuaranteeLateArrvInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
