<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate the effective day for the policy. | May be used to give further detail on the code or to remove an obsolete item. | Used to indicate the effective dates of the policy. | Describes the policies of the hotel, such as
 * the type of payments, or whether children or pets are accepted. | Policy information for this hotel.
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The CheckInTime
     * Meta information extracted from the WSDL
     * - documentation: The checkin time required by this hotel for a room stay.
     * - use: optional
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * Meta information extracted from the WSDL
     * - documentation: The checkout time required by this hotel for a room stay.
     * - use: optional
     * @var string
     */
    public $CheckOutTime;
    /**
     * The CancelPolicy
     * Meta information extracted from the WSDL
     * - documentation: Defines the cancellation policy of the hotel facility.
     * - minOccurs: 0
     * @var mixed
     */
    public $CancelPolicy;
    /**
     * The GuaranteePaymentPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuaranteePaymentPolicy
     */
    public $GuaranteePaymentPolicy;
    /**
     * The PolicyInfoCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyInfoCodes
     */
    public $PolicyInfoCodes;
    /**
     * The CheckoutCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CheckoutCharges
     */
    public $CheckoutCharges;
    /**
     * The PolicyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyInfo
     */
    public $PolicyInfo;
    /**
     * The TaxPolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxPolicies
     */
    public $TaxPolicies;
    /**
     * The PetsPolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PetsPolicies
     */
    public $PetsPolicies;
    /**
     * The StayRequirements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StayRequirements
     */
    public $StayRequirements;
    /**
     * The CommissionPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommissionPolicy
     */
    public $CommissionPolicy;
    /**
     * The FeePolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FeePolicies
     */
    public $FeePolicies;
    /**
     * The RatePolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePolicies
     */
    public $RatePolicies;
    /**
     * The GroupPolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GroupPolicies
     */
    public $GroupPolicies;
    /**
     * The DefaultValidBookingMinOffset
     * Meta information extracted from the WSDL
     * - documentation: Defines the default minimum number of days in advance that a booking must be made at this hotel.
     * - use: optional
     * @var int
     */
    public $DefaultValidBookingMinOffset;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The code identifying this policy.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when the policy information for this hotel was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for Policy
     * @uses Policy::setCheckInTime()
     * @uses Policy::setCheckOutTime()
     * @uses Policy::setCancelPolicy()
     * @uses Policy::setGuaranteePaymentPolicy()
     * @uses Policy::setPolicyInfoCodes()
     * @uses Policy::setCheckoutCharges()
     * @uses Policy::setPolicyInfo()
     * @uses Policy::setTaxPolicies()
     * @uses Policy::setPetsPolicies()
     * @uses Policy::setStayRequirements()
     * @uses Policy::setCommissionPolicy()
     * @uses Policy::setFeePolicies()
     * @uses Policy::setRatePolicies()
     * @uses Policy::setGroupPolicies()
     * @uses Policy::setDefaultValidBookingMinOffset()
     * @uses Policy::setCode()
     * @uses Policy::setLastUpdated()
     * @param string $checkInTime
     * @param string $checkOutTime
     * @param mixed $cancelPolicy
     * @param \StructType\GuaranteePaymentPolicy $guaranteePaymentPolicy
     * @param \StructType\PolicyInfoCodes $policyInfoCodes
     * @param \StructType\CheckoutCharges $checkoutCharges
     * @param \StructType\PolicyInfo $policyInfo
     * @param \StructType\TaxPolicies $taxPolicies
     * @param \StructType\PetsPolicies $petsPolicies
     * @param \StructType\StayRequirements $stayRequirements
     * @param \StructType\CommissionPolicy $commissionPolicy
     * @param \StructType\FeePolicies $feePolicies
     * @param \StructType\RatePolicies $ratePolicies
     * @param \StructType\GroupPolicies $groupPolicies
     * @param int $defaultValidBookingMinOffset
     * @param string $code
     * @param string $lastUpdated
     */
    public function __construct($checkInTime = null, $checkOutTime = null, $cancelPolicy = null, \StructType\GuaranteePaymentPolicy $guaranteePaymentPolicy = null, \StructType\PolicyInfoCodes $policyInfoCodes = null, \StructType\CheckoutCharges $checkoutCharges = null, \StructType\PolicyInfo $policyInfo = null, \StructType\TaxPolicies $taxPolicies = null, \StructType\PetsPolicies $petsPolicies = null, \StructType\StayRequirements $stayRequirements = null, \StructType\CommissionPolicy $commissionPolicy = null, \StructType\FeePolicies $feePolicies = null, \StructType\RatePolicies $ratePolicies = null, \StructType\GroupPolicies $groupPolicies = null, $defaultValidBookingMinOffset = null, $code = null, $lastUpdated = null)
    {
        $this
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime)
            ->setCancelPolicy($cancelPolicy)
            ->setGuaranteePaymentPolicy($guaranteePaymentPolicy)
            ->setPolicyInfoCodes($policyInfoCodes)
            ->setCheckoutCharges($checkoutCharges)
            ->setPolicyInfo($policyInfo)
            ->setTaxPolicies($taxPolicies)
            ->setPetsPolicies($petsPolicies)
            ->setStayRequirements($stayRequirements)
            ->setCommissionPolicy($commissionPolicy)
            ->setFeePolicies($feePolicies)
            ->setRatePolicies($ratePolicies)
            ->setGroupPolicies($groupPolicies)
            ->setDefaultValidBookingMinOffset($defaultValidBookingMinOffset)
            ->setCode($code)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \StructType\Policy
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \StructType\Policy
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
    /**
     * Get CancelPolicy value
     * @return mixed|null
     */
    public function getCancelPolicy()
    {
        return $this->CancelPolicy;
    }
    /**
     * Set CancelPolicy value
     * @param mixed $cancelPolicy
     * @return \StructType\Policy
     */
    public function setCancelPolicy($cancelPolicy = null)
    {
        $this->CancelPolicy = $cancelPolicy;
        return $this;
    }
    /**
     * Get GuaranteePaymentPolicy value
     * @return \StructType\GuaranteePaymentPolicy|null
     */
    public function getGuaranteePaymentPolicy()
    {
        return $this->GuaranteePaymentPolicy;
    }
    /**
     * Set GuaranteePaymentPolicy value
     * @param \StructType\GuaranteePaymentPolicy $guaranteePaymentPolicy
     * @return \StructType\Policy
     */
    public function setGuaranteePaymentPolicy(\StructType\GuaranteePaymentPolicy $guaranteePaymentPolicy = null)
    {
        $this->GuaranteePaymentPolicy = $guaranteePaymentPolicy;
        return $this;
    }
    /**
     * Get PolicyInfoCodes value
     * @return \StructType\PolicyInfoCodes|null
     */
    public function getPolicyInfoCodes()
    {
        return $this->PolicyInfoCodes;
    }
    /**
     * Set PolicyInfoCodes value
     * @param \StructType\PolicyInfoCodes $policyInfoCodes
     * @return \StructType\Policy
     */
    public function setPolicyInfoCodes(\StructType\PolicyInfoCodes $policyInfoCodes = null)
    {
        $this->PolicyInfoCodes = $policyInfoCodes;
        return $this;
    }
    /**
     * Get CheckoutCharges value
     * @return \StructType\CheckoutCharges|null
     */
    public function getCheckoutCharges()
    {
        return $this->CheckoutCharges;
    }
    /**
     * Set CheckoutCharges value
     * @param \StructType\CheckoutCharges $checkoutCharges
     * @return \StructType\Policy
     */
    public function setCheckoutCharges(\StructType\CheckoutCharges $checkoutCharges = null)
    {
        $this->CheckoutCharges = $checkoutCharges;
        return $this;
    }
    /**
     * Get PolicyInfo value
     * @return \StructType\PolicyInfo|null
     */
    public function getPolicyInfo()
    {
        return $this->PolicyInfo;
    }
    /**
     * Set PolicyInfo value
     * @param \StructType\PolicyInfo $policyInfo
     * @return \StructType\Policy
     */
    public function setPolicyInfo(\StructType\PolicyInfo $policyInfo = null)
    {
        $this->PolicyInfo = $policyInfo;
        return $this;
    }
    /**
     * Get TaxPolicies value
     * @return \StructType\TaxPolicies|null
     */
    public function getTaxPolicies()
    {
        return $this->TaxPolicies;
    }
    /**
     * Set TaxPolicies value
     * @param \StructType\TaxPolicies $taxPolicies
     * @return \StructType\Policy
     */
    public function setTaxPolicies(\StructType\TaxPolicies $taxPolicies = null)
    {
        $this->TaxPolicies = $taxPolicies;
        return $this;
    }
    /**
     * Get PetsPolicies value
     * @return \StructType\PetsPolicies|null
     */
    public function getPetsPolicies()
    {
        return $this->PetsPolicies;
    }
    /**
     * Set PetsPolicies value
     * @param \StructType\PetsPolicies $petsPolicies
     * @return \StructType\Policy
     */
    public function setPetsPolicies(\StructType\PetsPolicies $petsPolicies = null)
    {
        $this->PetsPolicies = $petsPolicies;
        return $this;
    }
    /**
     * Get StayRequirements value
     * @return \StructType\StayRequirements|null
     */
    public function getStayRequirements()
    {
        return $this->StayRequirements;
    }
    /**
     * Set StayRequirements value
     * @param \StructType\StayRequirements $stayRequirements
     * @return \StructType\Policy
     */
    public function setStayRequirements(\StructType\StayRequirements $stayRequirements = null)
    {
        $this->StayRequirements = $stayRequirements;
        return $this;
    }
    /**
     * Get CommissionPolicy value
     * @return \StructType\CommissionPolicy|null
     */
    public function getCommissionPolicy()
    {
        return $this->CommissionPolicy;
    }
    /**
     * Set CommissionPolicy value
     * @param \StructType\CommissionPolicy $commissionPolicy
     * @return \StructType\Policy
     */
    public function setCommissionPolicy(\StructType\CommissionPolicy $commissionPolicy = null)
    {
        $this->CommissionPolicy = $commissionPolicy;
        return $this;
    }
    /**
     * Get FeePolicies value
     * @return \StructType\FeePolicies|null
     */
    public function getFeePolicies()
    {
        return $this->FeePolicies;
    }
    /**
     * Set FeePolicies value
     * @param \StructType\FeePolicies $feePolicies
     * @return \StructType\Policy
     */
    public function setFeePolicies(\StructType\FeePolicies $feePolicies = null)
    {
        $this->FeePolicies = $feePolicies;
        return $this;
    }
    /**
     * Get RatePolicies value
     * @return \StructType\RatePolicies|null
     */
    public function getRatePolicies()
    {
        return $this->RatePolicies;
    }
    /**
     * Set RatePolicies value
     * @param \StructType\RatePolicies $ratePolicies
     * @return \StructType\Policy
     */
    public function setRatePolicies(\StructType\RatePolicies $ratePolicies = null)
    {
        $this->RatePolicies = $ratePolicies;
        return $this;
    }
    /**
     * Get GroupPolicies value
     * @return \StructType\GroupPolicies|null
     */
    public function getGroupPolicies()
    {
        return $this->GroupPolicies;
    }
    /**
     * Set GroupPolicies value
     * @param \StructType\GroupPolicies $groupPolicies
     * @return \StructType\Policy
     */
    public function setGroupPolicies(\StructType\GroupPolicies $groupPolicies = null)
    {
        $this->GroupPolicies = $groupPolicies;
        return $this;
    }
    /**
     * Get DefaultValidBookingMinOffset value
     * @return int|null
     */
    public function getDefaultValidBookingMinOffset()
    {
        return $this->DefaultValidBookingMinOffset;
    }
    /**
     * Set DefaultValidBookingMinOffset value
     * @param int $defaultValidBookingMinOffset
     * @return \StructType\Policy
     */
    public function setDefaultValidBookingMinOffset($defaultValidBookingMinOffset = null)
    {
        // validation for constraint: int
        if (!is_null($defaultValidBookingMinOffset) && !(is_int($defaultValidBookingMinOffset) || ctype_digit($defaultValidBookingMinOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultValidBookingMinOffset, true), gettype($defaultValidBookingMinOffset)), __LINE__);
        }
        $this->DefaultValidBookingMinOffset = $defaultValidBookingMinOffset;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Policy
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\Policy
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Policy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
