<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The start date and duration of the package. | To retrieve a package reservation record when the booking reference is not known.
 * @subpackage Structs
 */
class PkgReadRequest extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the lead passenger on the booking.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The ArrivalLocation
     * Meta information extracted from the WSDL
     * - documentation: The code for the final destination - normally an IATA airport code.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ArrivalLocation;
    /**
     * The DepartureLocation
     * Meta information extracted from the WSDL
     * - documentation: The code for the traveller's departure point - normally an IATA airport code.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $DepartureLocation;
    /**
     * The TravelCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the travel arrangement for the package. | Used for Character Strings, length 1 to 8. | The supplier's code to identify the travel arrangement for the package
     * - base: StringLength1to8
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TravelCode;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the accommodation/tour arrangement for a package
     * - use: optional
     * @var string
     */
    public $TourCode;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - documentation: A code identifying a complete package arrangement, replacing individual travel and accommodation codes. | Used for Character Strings, length 1 to 32.
     * - base: StringLength1to32
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PackageID;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for PkgReadRequest
     * @uses PkgReadRequest::setName()
     * @uses PkgReadRequest::setArrivalLocation()
     * @uses PkgReadRequest::setDepartureLocation()
     * @uses PkgReadRequest::setTravelCode()
     * @uses PkgReadRequest::setTourCode()
     * @uses PkgReadRequest::setPackageID()
     * @uses PkgReadRequest::setStart()
     * @uses PkgReadRequest::setDuration()
     * @uses PkgReadRequest::setEnd()
     * @param \StructType\PersonNameType $name
     * @param \StructType\LocationType $arrivalLocation
     * @param \StructType\LocationType $departureLocation
     * @param string $travelCode
     * @param string $tourCode
     * @param string $packageID
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\PersonNameType $name = null, \StructType\LocationType $arrivalLocation = null, \StructType\LocationType $departureLocation = null, $travelCode = null, $tourCode = null, $packageID = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setName($name)
            ->setArrivalLocation($arrivalLocation)
            ->setDepartureLocation($departureLocation)
            ->setTravelCode($travelCode)
            ->setTourCode($tourCode)
            ->setPackageID($packageID)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\PkgReadRequest
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return \StructType\LocationType|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param \StructType\LocationType $arrivalLocation
     * @return \StructType\PkgReadRequest
     */
    public function setArrivalLocation(\StructType\LocationType $arrivalLocation = null)
    {
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get DepartureLocation value
     * @return \StructType\LocationType|null
     */
    public function getDepartureLocation()
    {
        return $this->DepartureLocation;
    }
    /**
     * Set DepartureLocation value
     * @param \StructType\LocationType $departureLocation
     * @return \StructType\PkgReadRequest
     */
    public function setDepartureLocation(\StructType\LocationType $departureLocation = null)
    {
        $this->DepartureLocation = $departureLocation;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return string|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param string $travelCode
     * @return \StructType\PkgReadRequest
     */
    public function setTravelCode($travelCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelCode) && !is_string($travelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelCode, true), gettype($travelCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($travelCode) && mb_strlen($travelCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($travelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($travelCode) && mb_strlen($travelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($travelCode)), __LINE__);
        }
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\PkgReadRequest
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \StructType\PkgReadRequest
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($packageID) && mb_strlen($packageID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($packageID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageID) && mb_strlen($packageID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\PkgReadRequest
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\PkgReadRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\PkgReadRequest
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
