<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgInvoiceDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: A list of all the items making up a costed booking
 * @subpackage Structs
 */
class PkgInvoiceDetail extends AbstractStructBase
{
    /**
     * The CostingItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CostingItems
     */
    public $CostingItems;
    /**
     * The GrossAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GrossAmount
     */
    public $GrossAmount;
    /**
     * The DepositAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepositAmount
     */
    public $DepositAmount;
    /**
     * The AgentCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \StructType\AgentCommission[]
     */
    public $AgentCommission;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NetAmount
     */
    public $NetAmount;
    /**
     * The TaxItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of tax item lines.
     * - minOccurs: 0
     * @var mixed
     */
    public $TaxItems;
    /**
     * The BalanceDueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BalanceDueAmount
     */
    public $BalanceDueAmount;
    /**
     * The AmountReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AmountReceived
     */
    public $AmountReceived;
    /**
     * Constructor method for PkgInvoiceDetail
     * @uses PkgInvoiceDetail::setCostingItems()
     * @uses PkgInvoiceDetail::setGrossAmount()
     * @uses PkgInvoiceDetail::setDepositAmount()
     * @uses PkgInvoiceDetail::setAgentCommission()
     * @uses PkgInvoiceDetail::setNetAmount()
     * @uses PkgInvoiceDetail::setTaxItems()
     * @uses PkgInvoiceDetail::setBalanceDueAmount()
     * @uses PkgInvoiceDetail::setAmountReceived()
     * @param \StructType\CostingItems $costingItems
     * @param \StructType\GrossAmount $grossAmount
     * @param \StructType\DepositAmount $depositAmount
     * @param \StructType\AgentCommission[] $agentCommission
     * @param \StructType\NetAmount $netAmount
     * @param mixed $taxItems
     * @param \StructType\BalanceDueAmount $balanceDueAmount
     * @param \StructType\AmountReceived $amountReceived
     */
    public function __construct(\StructType\CostingItems $costingItems = null, \StructType\GrossAmount $grossAmount = null, \StructType\DepositAmount $depositAmount = null, array $agentCommission = array(), \StructType\NetAmount $netAmount = null, $taxItems = null, \StructType\BalanceDueAmount $balanceDueAmount = null, \StructType\AmountReceived $amountReceived = null)
    {
        $this
            ->setCostingItems($costingItems)
            ->setGrossAmount($grossAmount)
            ->setDepositAmount($depositAmount)
            ->setAgentCommission($agentCommission)
            ->setNetAmount($netAmount)
            ->setTaxItems($taxItems)
            ->setBalanceDueAmount($balanceDueAmount)
            ->setAmountReceived($amountReceived);
    }
    /**
     * Get CostingItems value
     * @return \StructType\CostingItems|null
     */
    public function getCostingItems()
    {
        return $this->CostingItems;
    }
    /**
     * Set CostingItems value
     * @param \StructType\CostingItems $costingItems
     * @return \StructType\PkgInvoiceDetail
     */
    public function setCostingItems(\StructType\CostingItems $costingItems = null)
    {
        $this->CostingItems = $costingItems;
        return $this;
    }
    /**
     * Get GrossAmount value
     * @return \StructType\GrossAmount|null
     */
    public function getGrossAmount()
    {
        return $this->GrossAmount;
    }
    /**
     * Set GrossAmount value
     * @param \StructType\GrossAmount $grossAmount
     * @return \StructType\PkgInvoiceDetail
     */
    public function setGrossAmount(\StructType\GrossAmount $grossAmount = null)
    {
        $this->GrossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return \StructType\DepositAmount|null
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param \StructType\DepositAmount $depositAmount
     * @return \StructType\PkgInvoiceDetail
     */
    public function setDepositAmount(\StructType\DepositAmount $depositAmount = null)
    {
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get AgentCommission value
     * @return \StructType\AgentCommission[]|null
     */
    public function getAgentCommission()
    {
        return $this->AgentCommission;
    }
    /**
     * This method is responsible for validating the values passed to the setAgentCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentCommissionForArrayConstraintsFromSetAgentCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pkgInvoiceDetailAgentCommissionItem) {
            // validation for constraint: itemType
            if (!$pkgInvoiceDetailAgentCommissionItem instanceof \StructType\AgentCommission) {
                $invalidValues[] = is_object($pkgInvoiceDetailAgentCommissionItem) ? get_class($pkgInvoiceDetailAgentCommissionItem) : sprintf('%s(%s)', gettype($pkgInvoiceDetailAgentCommissionItem), var_export($pkgInvoiceDetailAgentCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgentCommission property can only contain items of type \StructType\AgentCommission, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgentCommission value
     * @throws \InvalidArgumentException
     * @param \StructType\AgentCommission[] $agentCommission
     * @return \StructType\PkgInvoiceDetail
     */
    public function setAgentCommission(array $agentCommission = array())
    {
        // validation for constraint: array
        if ('' !== ($agentCommissionArrayErrorMessage = self::validateAgentCommissionForArrayConstraintsFromSetAgentCommission($agentCommission))) {
            throw new \InvalidArgumentException($agentCommissionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($agentCommission) && count($agentCommission) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 8', count($agentCommission)), __LINE__);
        }
        $this->AgentCommission = $agentCommission;
        return $this;
    }
    /**
     * Add item to AgentCommission value
     * @throws \InvalidArgumentException
     * @param \StructType\AgentCommission $item
     * @return \StructType\PkgInvoiceDetail
     */
    public function addToAgentCommission(\StructType\AgentCommission $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AgentCommission) {
            throw new \InvalidArgumentException(sprintf('The AgentCommission property can only contain items of type \StructType\AgentCommission, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($this->AgentCommission) && count($this->AgentCommission) >= 8) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 8', count($this->AgentCommission)), __LINE__);
        }
        $this->AgentCommission[] = $item;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return \StructType\NetAmount|null
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param \StructType\NetAmount $netAmount
     * @return \StructType\PkgInvoiceDetail
     */
    public function setNetAmount(\StructType\NetAmount $netAmount = null)
    {
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get TaxItems value
     * @return mixed|null
     */
    public function getTaxItems()
    {
        return $this->TaxItems;
    }
    /**
     * Set TaxItems value
     * @param mixed $taxItems
     * @return \StructType\PkgInvoiceDetail
     */
    public function setTaxItems($taxItems = null)
    {
        $this->TaxItems = $taxItems;
        return $this;
    }
    /**
     * Get BalanceDueAmount value
     * @return \StructType\BalanceDueAmount|null
     */
    public function getBalanceDueAmount()
    {
        return $this->BalanceDueAmount;
    }
    /**
     * Set BalanceDueAmount value
     * @param \StructType\BalanceDueAmount $balanceDueAmount
     * @return \StructType\PkgInvoiceDetail
     */
    public function setBalanceDueAmount(\StructType\BalanceDueAmount $balanceDueAmount = null)
    {
        $this->BalanceDueAmount = $balanceDueAmount;
        return $this;
    }
    /**
     * Get AmountReceived value
     * @return \StructType\AmountReceived|null
     */
    public function getAmountReceived()
    {
        return $this->AmountReceived;
    }
    /**
     * Set AmountReceived value
     * @param \StructType\AmountReceived $amountReceived
     * @return \StructType\PkgInvoiceDetail
     */
    public function setAmountReceived(\StructType\AmountReceived $amountReceived = null)
    {
        $this->AmountReceived = $amountReceived;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgInvoiceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
