<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgCautionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information regarding a package component which could affect a customer's decision to book.
 * @subpackage Structs
 */
class PkgCautionType extends FormattedTextTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of information e.g. Resort, Flight, Accommodation etc..
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The supplier's unique identification code for a caution.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The ListOfItineraryItemRPH
     * Meta information extracted from the WSDL
     * - documentation: Pointers to individual InventoryItem elements to which this Caution applies.
     * - use: optional
     * @var list
     */
    public $ListOfItineraryItemRPH;
    /**
     * The ListOfExtraRPH
     * Meta information extracted from the WSDL
     * - documentation: Pointers to individual Extra elements to which this Caution applies.
     * - use: optional
     * @var list
     */
    public $ListOfExtraRPH;
    /**
     * Constructor method for PkgCautionType
     * @uses PkgCautionType::setType()
     * @uses PkgCautionType::setID()
     * @uses PkgCautionType::setListOfItineraryItemRPH()
     * @uses PkgCautionType::setListOfExtraRPH()
     * @param string $type
     * @param string $iD
     * @param list $listOfItineraryItemRPH
     * @param list $listOfExtraRPH
     */
    public function __construct($type = null, $iD = null, list $listOfItineraryItemRPH = null, list $listOfExtraRPH = null)
    {
        $this
            ->setType($type)
            ->setID($iD)
            ->setListOfItineraryItemRPH($listOfItineraryItemRPH)
            ->setListOfExtraRPH($listOfExtraRPH);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PkgCautionType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\PkgCautionType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ListOfItineraryItemRPH value
     * @return list|null
     */
    public function getListOfItineraryItemRPH()
    {
        return $this->ListOfItineraryItemRPH;
    }
    /**
     * Set ListOfItineraryItemRPH value
     * @param list $listOfItineraryItemRPH
     * @return \StructType\PkgCautionType
     */
    public function setListOfItineraryItemRPH(list $listOfItineraryItemRPH = null)
    {
        $this->ListOfItineraryItemRPH = $listOfItineraryItemRPH;
        return $this;
    }
    /**
     * Get ListOfExtraRPH value
     * @return list|null
     */
    public function getListOfExtraRPH()
    {
        return $this->ListOfExtraRPH;
    }
    /**
     * Set ListOfExtraRPH value
     * @param list $listOfExtraRPH
     * @return \StructType\PkgCautionType
     */
    public function setListOfExtraRPH(list $listOfExtraRPH = null)
    {
        $this->ListOfExtraRPH = $listOfExtraRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgCautionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
