<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgAirSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides details of an air segment
 * @subpackage Structs
 */
class PkgAirSegmentType extends FlightSegmentBaseType
{
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - documentation: A value representing a supplement for this journey (e.g. Aberdeen to Palma) over the cost of the journey on which package basic price is calculated (e.g. Gatwick to Palma). The element repeats to allow for charges in an alternative
     * currency to be shown.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SupplementCharges;
    /**
     * The AvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailableSeats
     */
    public $AvailableSeats;
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Passengers
     */
    public $Passengers;
    /**
     * The CheckInDate
     * Meta information extracted from the WSDL
     * - documentation: Provides the recommended date and time of passenger check-in.
     * - use: optional
     * @var string
     */
    public $CheckInDate;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The DepartureDay
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DepartureDay;
    /**
     * The TravelCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the travel arrangement for the package
     * - use: optional
     * @var mixed
     */
    public $TravelCode;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: A length of time.
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * Constructor method for PkgAirSegmentType
     * @uses PkgAirSegmentType::setSupplementCharges()
     * @uses PkgAirSegmentType::setAvailableSeats()
     * @uses PkgAirSegmentType::setPassengers()
     * @uses PkgAirSegmentType::setCheckInDate()
     * @uses PkgAirSegmentType::setType()
     * @uses PkgAirSegmentType::setDepartureDay()
     * @uses PkgAirSegmentType::setTravelCode()
     * @uses PkgAirSegmentType::setDuration()
     * @param mixed[] $supplementCharges
     * @param \StructType\AvailableSeats $availableSeats
     * @param \StructType\Passengers $passengers
     * @param string $checkInDate
     * @param string $type
     * @param string $departureDay
     * @param mixed $travelCode
     * @param string $duration
     */
    public function __construct(array $supplementCharges = array(), \StructType\AvailableSeats $availableSeats = null, \StructType\Passengers $passengers = null, $checkInDate = null, $type = null, $departureDay = null, $travelCode = null, $duration = null)
    {
        $this
            ->setSupplementCharges($supplementCharges)
            ->setAvailableSeats($availableSeats)
            ->setPassengers($passengers)
            ->setCheckInDate($checkInDate)
            ->setType($type)
            ->setDepartureDay($departureDay)
            ->setTravelCode($travelCode)
            ->setDuration($duration);
    }
    /**
     * Get SupplementCharges value
     * @return mixed[]|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplementCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementChargesForArrayConstraintsFromSetSupplementCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pkgAirSegmentTypeSupplementChargesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pkgAirSegmentTypeSupplementChargesItem) ? get_class($pkgAirSegmentTypeSupplementChargesItem) : sprintf('%s(%s)', gettype($pkgAirSegmentTypeSupplementChargesItem), var_export($pkgAirSegmentTypeSupplementChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplementCharges property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplementCharges value
     * @throws \InvalidArgumentException
     * @param mixed[] $supplementCharges
     * @return \StructType\PkgAirSegmentType
     */
    public function setSupplementCharges(array $supplementCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementChargesArrayErrorMessage = self::validateSupplementChargesForArrayConstraintsFromSetSupplementCharges($supplementCharges))) {
            throw new \InvalidArgumentException($supplementChargesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($supplementCharges) && count($supplementCharges) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($supplementCharges)), __LINE__);
        }
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Add item to SupplementCharges value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PkgAirSegmentType
     */
    public function addToSupplementCharges($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SupplementCharges property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->SupplementCharges) && count($this->SupplementCharges) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->SupplementCharges)), __LINE__);
        }
        $this->SupplementCharges[] = $item;
        return $this;
    }
    /**
     * Get AvailableSeats value
     * @return \StructType\AvailableSeats|null
     */
    public function getAvailableSeats()
    {
        return $this->AvailableSeats;
    }
    /**
     * Set AvailableSeats value
     * @param \StructType\AvailableSeats $availableSeats
     * @return \StructType\PkgAirSegmentType
     */
    public function setAvailableSeats(\StructType\AvailableSeats $availableSeats = null)
    {
        $this->AvailableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \StructType\Passengers|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \StructType\Passengers $passengers
     * @return \StructType\PkgAirSegmentType
     */
    public function setPassengers(\StructType\Passengers $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\PkgAirSegmentType
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PkgAirSegmentType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DepartureDay value
     * @return string|null
     */
    public function getDepartureDay()
    {
        return $this->DepartureDay;
    }
    /**
     * Set DepartureDay value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureDay
     * @return \StructType\PkgAirSegmentType
     */
    public function setDepartureDay($departureDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($departureDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($departureDay) ? implode(', ', $departureDay) : var_export($departureDay, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DepartureDay = $departureDay;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return mixed|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param mixed $travelCode
     * @return \StructType\PkgAirSegmentType
     */
    public function setTravelCode($travelCode = null)
    {
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\PkgAirSegmentType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgAirSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
