<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Periods StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of prices by booking period.
 * @subpackage Structs
 */
class Periods extends AbstractStructBase
{
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - documentation: The price of the Extra per unit (which may be person, room, car etc,) and/or duration
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Period;
    /**
     * Constructor method for Periods
     * @uses Periods::setPeriod()
     * @param mixed[] $period
     */
    public function __construct(array $period = array())
    {
        $this
            ->setPeriod($period);
    }
    /**
     * Get Period value
     * @return mixed[]|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodForArrayConstraintsFromSetPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $periodsPeriodItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($periodsPeriodItem) ? get_class($periodsPeriodItem) : sprintf('%s(%s)', gettype($periodsPeriodItem), var_export($periodsPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Period property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Period value
     * @throws \InvalidArgumentException
     * @param mixed[] $period
     * @return \StructType\Periods
     */
    public function setPeriod(array $period = array())
    {
        // validation for constraint: array
        if ('' !== ($periodArrayErrorMessage = self::validatePeriodForArrayConstraintsFromSetPeriod($period))) {
            throw new \InvalidArgumentException($periodArrayErrorMessage, __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Add item to Period value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Periods
     */
    public function addToPeriod($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Period property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Period[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Periods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
