<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentsDue StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of payments due.
 * @subpackage Structs
 */
class PaymentsDue extends AbstractStructBase
{
    /**
     * The PaymentDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PaymentDue[]
     */
    public $PaymentDue;
    /**
     * Constructor method for PaymentsDue
     * @uses PaymentsDue::setPaymentDue()
     * @param \StructType\PaymentDue[] $paymentDue
     */
    public function __construct(array $paymentDue = array())
    {
        $this
            ->setPaymentDue($paymentDue);
    }
    /**
     * Get PaymentDue value
     * @return \StructType\PaymentDue[]|null
     */
    public function getPaymentDue()
    {
        return $this->PaymentDue;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDueForArrayConstraintsFromSetPaymentDue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentsDuePaymentDueItem) {
            // validation for constraint: itemType
            if (!$paymentsDuePaymentDueItem instanceof \StructType\PaymentDue) {
                $invalidValues[] = is_object($paymentsDuePaymentDueItem) ? get_class($paymentsDuePaymentDueItem) : sprintf('%s(%s)', gettype($paymentsDuePaymentDueItem), var_export($paymentsDuePaymentDueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDue property can only contain items of type \StructType\PaymentDue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDue value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDue[] $paymentDue
     * @return \StructType\PaymentsDue
     */
    public function setPaymentDue(array $paymentDue = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDueArrayErrorMessage = self::validatePaymentDueForArrayConstraintsFromSetPaymentDue($paymentDue))) {
            throw new \InvalidArgumentException($paymentDueArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($paymentDue) && count($paymentDue) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($paymentDue)), __LINE__);
        }
        $this->PaymentDue = $paymentDue;
        return $this;
    }
    /**
     * Add item to PaymentDue value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDue $item
     * @return \StructType\PaymentsDue
     */
    public function addToPaymentDue(\StructType\PaymentDue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentDue) {
            throw new \InvalidArgumentException(sprintf('The PaymentDue property can only contain items of type \StructType\PaymentDue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PaymentDue) && count($this->PaymentDue) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PaymentDue)), __LINE__);
        }
        $this->PaymentDue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentsDue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
