<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRules StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of payment rules associated with this reservation. | A collection of payment rules associated with this reservation. This instance of PaymentRules would be used if there were payment rules that were applicable to a
 * specific vehicle type. | A collection of payment rules associated with this rail reservation.
 * @subpackage Structs
 */
class PaymentRules extends PaymentRulesType
{
    /**
     * The AcceptablePayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\AcceptablePayments[]
     */
    public $AcceptablePayments;
    /**
     * The PaymentRule
     * Meta information extracted from the WSDL
     * - documentation: One specific payment rule associated with this reservation. For example, a date by which a deposit must be received. | A specific payment rule associated with this reservation.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $PaymentRule;
    /**
     * Constructor method for PaymentRules
     * @uses PaymentRules::setAcceptablePayments()
     * @uses PaymentRules::setPaymentRule()
     * @param \StructType\AcceptablePayments[] $acceptablePayments
     * @param mixed[] $paymentRule
     */
    public function __construct(array $acceptablePayments = array(), array $paymentRule = array())
    {
        $this
            ->setAcceptablePayments($acceptablePayments)
            ->setPaymentRule($paymentRule);
    }
    /**
     * Get AcceptablePayments value
     * @return \StructType\AcceptablePayments[]|null
     */
    public function getAcceptablePayments()
    {
        return $this->AcceptablePayments;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptablePayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptablePayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptablePaymentsForArrayConstraintsFromSetAcceptablePayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRulesAcceptablePaymentsItem) {
            // validation for constraint: itemType
            if (!$paymentRulesAcceptablePaymentsItem instanceof \StructType\AcceptablePayments) {
                $invalidValues[] = is_object($paymentRulesAcceptablePaymentsItem) ? get_class($paymentRulesAcceptablePaymentsItem) : sprintf('%s(%s)', gettype($paymentRulesAcceptablePaymentsItem), var_export($paymentRulesAcceptablePaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptablePayments property can only contain items of type \StructType\AcceptablePayments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptablePayments value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePayments[] $acceptablePayments
     * @return \StructType\PaymentRules
     */
    public function setAcceptablePayments(array $acceptablePayments = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptablePaymentsArrayErrorMessage = self::validateAcceptablePaymentsForArrayConstraintsFromSetAcceptablePayments($acceptablePayments))) {
            throw new \InvalidArgumentException($acceptablePaymentsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($acceptablePayments) && count($acceptablePayments) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($acceptablePayments)), __LINE__);
        }
        $this->AcceptablePayments = $acceptablePayments;
        return $this;
    }
    /**
     * Add item to AcceptablePayments value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePayments $item
     * @return \StructType\PaymentRules
     */
    public function addToAcceptablePayments(\StructType\AcceptablePayments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptablePayments) {
            throw new \InvalidArgumentException(sprintf('The AcceptablePayments property can only contain items of type \StructType\AcceptablePayments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->AcceptablePayments) && count($this->AcceptablePayments) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->AcceptablePayments)), __LINE__);
        }
        $this->AcceptablePayments[] = $item;
        return $this;
    }
    /**
     * Get PaymentRule value
     * @return mixed[]|null
     */
    public function getPaymentRule()
    {
        return $this->PaymentRule;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentRuleForArrayConstraintsFromSetPaymentRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRulesPaymentRuleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($paymentRulesPaymentRuleItem) ? get_class($paymentRulesPaymentRuleItem) : sprintf('%s(%s)', gettype($paymentRulesPaymentRuleItem), var_export($paymentRulesPaymentRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentRule property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentRule value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentRule
     * @return \StructType\PaymentRules
     */
    public function setPaymentRule(array $paymentRule = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentRuleArrayErrorMessage = self::validatePaymentRuleForArrayConstraintsFromSetPaymentRule($paymentRule))) {
            throw new \InvalidArgumentException($paymentRuleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentRule) && count($paymentRule) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentRule)), __LINE__);
        }
        $this->PaymentRule = $paymentRule;
        return $this;
    }
    /**
     * Add item to PaymentRule value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PaymentRules
     */
    public function addToPaymentRule($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentRule) && count($this->PaymentRule) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentRule)), __LINE__);
        }
        $this->PaymentRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
