<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of payment.
 * @subpackage Structs
 */
class PaymentDetailType extends PaymentFormType
{
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\PaymentAmount[]
     */
    public $PaymentAmount;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the commission details when paid to a third or internal party.
     * - minOccurs: 0
     * @var mixed
     */
    public $Commission;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the form of payment. Refer to OpenTravel Code List Payment Type (PMT).
     * - use: optional
     * @var string
     */
    public $PaymentType;
    /**
     * The SplitPaymentInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that more than one form of payment will be used.
     * - use: optional
     * @var bool
     */
    public $SplitPaymentInd;
    /**
     * The AuthorizedDays
     * Meta information extracted from the WSDL
     * - documentation: Number of days being charged to this payment method.
     * - use: optional
     * @var int
     */
    public $AuthorizedDays;
    /**
     * The PrimaryPaymentInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates this is the primary method of payment.
     * - use: optional
     * @var bool
     */
    public $PrimaryPaymentInd;
    /**
     * Constructor method for PaymentDetailType
     * @uses PaymentDetailType::setPaymentAmount()
     * @uses PaymentDetailType::setCommission()
     * @uses PaymentDetailType::setPaymentType()
     * @uses PaymentDetailType::setSplitPaymentInd()
     * @uses PaymentDetailType::setAuthorizedDays()
     * @uses PaymentDetailType::setPrimaryPaymentInd()
     * @param \StructType\PaymentAmount[] $paymentAmount
     * @param mixed $commission
     * @param string $paymentType
     * @param bool $splitPaymentInd
     * @param int $authorizedDays
     * @param bool $primaryPaymentInd
     */
    public function __construct(array $paymentAmount = array(), $commission = null, $paymentType = null, $splitPaymentInd = null, $authorizedDays = null, $primaryPaymentInd = null)
    {
        $this
            ->setPaymentAmount($paymentAmount)
            ->setCommission($commission)
            ->setPaymentType($paymentType)
            ->setSplitPaymentInd($splitPaymentInd)
            ->setAuthorizedDays($authorizedDays)
            ->setPrimaryPaymentInd($primaryPaymentInd);
    }
    /**
     * Get PaymentAmount value
     * @return \StructType\PaymentAmount[]|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentAmountForArrayConstraintsFromSetPaymentAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentDetailTypePaymentAmountItem) {
            // validation for constraint: itemType
            if (!$paymentDetailTypePaymentAmountItem instanceof \StructType\PaymentAmount) {
                $invalidValues[] = is_object($paymentDetailTypePaymentAmountItem) ? get_class($paymentDetailTypePaymentAmountItem) : sprintf('%s(%s)', gettype($paymentDetailTypePaymentAmountItem), var_export($paymentDetailTypePaymentAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentAmount property can only contain items of type \StructType\PaymentAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAmount[] $paymentAmount
     * @return \StructType\PaymentDetailType
     */
    public function setPaymentAmount(array $paymentAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentAmountArrayErrorMessage = self::validatePaymentAmountForArrayConstraintsFromSetPaymentAmount($paymentAmount))) {
            throw new \InvalidArgumentException($paymentAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($paymentAmount) && count($paymentAmount) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Add item to PaymentAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAmount $item
     * @return \StructType\PaymentDetailType
     */
    public function addToPaymentAmount(\StructType\PaymentAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentAmount) {
            throw new \InvalidArgumentException(sprintf('The PaymentAmount property can only contain items of type \StructType\PaymentAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->PaymentAmount) && count($this->PaymentAmount) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->PaymentAmount)), __LINE__);
        }
        $this->PaymentAmount[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return mixed|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param mixed $commission
     * @return \StructType\PaymentDetailType
     */
    public function setCommission($commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\PaymentDetailType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get SplitPaymentInd value
     * @return bool|null
     */
    public function getSplitPaymentInd()
    {
        return $this->SplitPaymentInd;
    }
    /**
     * Set SplitPaymentInd value
     * @param bool $splitPaymentInd
     * @return \StructType\PaymentDetailType
     */
    public function setSplitPaymentInd($splitPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitPaymentInd) && !is_bool($splitPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($splitPaymentInd, true), gettype($splitPaymentInd)), __LINE__);
        }
        $this->SplitPaymentInd = $splitPaymentInd;
        return $this;
    }
    /**
     * Get AuthorizedDays value
     * @return int|null
     */
    public function getAuthorizedDays()
    {
        return $this->AuthorizedDays;
    }
    /**
     * Set AuthorizedDays value
     * @param int $authorizedDays
     * @return \StructType\PaymentDetailType
     */
    public function setAuthorizedDays($authorizedDays = null)
    {
        // validation for constraint: int
        if (!is_null($authorizedDays) && !(is_int($authorizedDays) || ctype_digit($authorizedDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($authorizedDays, true), gettype($authorizedDays)), __LINE__);
        }
        $this->AuthorizedDays = $authorizedDays;
        return $this;
    }
    /**
     * Get PrimaryPaymentInd value
     * @return bool|null
     */
    public function getPrimaryPaymentInd()
    {
        return $this->PrimaryPaymentInd;
    }
    /**
     * Set PrimaryPaymentInd value
     * @param bool $primaryPaymentInd
     * @return \StructType\PaymentDetailType
     */
    public function setPrimaryPaymentInd($primaryPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryPaymentInd) && !is_bool($primaryPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryPaymentInd, true), gettype($primaryPaymentInd)), __LINE__);
        }
        $this->PrimaryPaymentInd = $primaryPaymentInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
