<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardType StructType
 * Meta information extracted from the WSDL
 * - documentation: Effective and expiration dates. | Data use and sharing permissions. | OpenTravel Best Practice: Use of Encrypted, Masked or Tokenized Information: Certain OpenTravel schema may have combinations payment and/or account information
 * with other personally identifying information, such as customer name and date of birth. For enhanced customer privacy and security, it is RECOMMENDED that the payment and account information be protected, using tokenization or some other encryption
 * method and displayed in a masked format. | Specific payment card information.
 * @subpackage Structs
 */
class PaymentCardType extends AbstractStructBase
{
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: Example: Mastercard | Payment card type.
     * - minOccurs: 0
     * @var mixed
     */
    public $CardType;
    /**
     * The Issuer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Issuer
     */
    public $Issuer;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - documentation: Card holder name.
     * - minOccurs: 0
     * @var mixed
     */
    public $CardHolderName;
    /**
     * The CardHolderNameDetails
     * Meta information extracted from the WSDL
     * - documentation: Description: The details of the Card Holder's Name.
     * - minOccurs: 0
     * @var mixed
     */
    public $CardHolderNameDetails;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Card holder address.
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Card holder email.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Email;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Payment Instruction Tokens-Any elements containing a token value MUST NOT and WILL NOT contain unmasked card account numbers, magnetic stripe data, or card security codes (CVV2,CVC, etc.) in other attributes
     * or elements. | Credit card number embossed on the card.
     * - minOccurs: 0
     * @var mixed
     */
    public $CardNumber;
    /**
     * The SeriesCode
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Payment Instruction Tokens-Any elements containing a token value MUST NOT and WILL NOT contain unmasked card account numbers, magnetic stripe data, or card security codes (CVV2,CVC, etc.) in other attributes
     * or elements. | Note: This is the verification digits printed on the card following the embossed number. This may also accommodate the customer identification/batch number (CID), card verification value (CVV2 ), card validation code number (CVC2) on
     * credit card. | Verification digits.
     * - minOccurs: 0
     * @var mixed
     */
    public $SeriesCode;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The MagneticStripe
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Credit Card Payment Instruction Tokens: Any elements containing a token value MUST NOT and WILL NOT contain unmasked card account numbers, magnetic stripe data, or card security codes (CVV2, CVC, etc.) in
     * other attributes or elements. | Magnetic stripe.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MagneticStripe;
    /**
     * The ThreeDomainSecurity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ThreeDomainSecurity
     */
    public $ThreeDomainSecurity;
    /**
     * The SignatureOnFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignatureOnFile
     */
    public $SignatureOnFile;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ExtendedPaymentInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the credit card company is requested to delay the date on which the amount of this transaction is applied to the customer's account. | Example: true | Extended payments indicator.
     * - use: optional
     * @var bool
     */
    public $ExtendedPaymentInd;
    /**
     * The SecureInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, all or a portion of this data is secure, via tokenization, encryption and/or masking. | Example: true | Secure data indicator.
     * - use: optional
     * @var bool
     */
    public $SecureInd;
    /**
     * The SignatureOnFileInd
     * Meta information extracted from the WSDL
     * - documentation: Example: true | Implementer: If true, the cardholder signature is on file. | Cardholder signature on file indicator.
     * - use: optional
     * @var bool
     */
    public $SignatureOnFileInd;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - documentation: DEPRECATION WARNING: This attribute will be deprecated in the 2012B publication. It will be replaced with the List_PaymentCardCode Open List. | Example: MC | Issuer code.
     * - use: optional
     * @var string
     */
    public $CardCode;
    /**
     * The CardHolderRPH
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Using Reference Place Holders: The reference place holder (RPH) is a unique ID assigned to an instance in a collection of like items (e.g. used to assign a unique ID to each passenger in a list of
     * passengers. When referencing an RPH, the same RPH type is used to identify the assigned unique ID in an element that references the item in a collection. | Note: This card holder reference ID was defined elsewhere in this message. | Example: 1 | Card
     * Holder Reference ID.
     * - use: optional
     * @var string
     */
    public $CardHolderRPH;
    /**
     * The CompanyCardReference
     * Meta information extracted from the WSDL
     * - documentation: Note: This is a reference for a company sponsor for the card. | Example: Universal Airline Travel Plan | Company sponsor.
     * - use: optional
     * @var string
     */
    public $CompanyCardReference;
    /**
     * The CountryOfIssue
     * Meta information extracted from the WSDL
     * - documentation: Example: US | Country of issue code.
     * - use: optional
     * @var string
     */
    public $CountryOfIssue;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Example: Travel rewards card. | Remark.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Using Reference Place Holders: The reference place holder (RPH) is a unique ID assigned to an instance in a collection of like items (e.g. used to assign a unique ID to each passenger in a list of
     * passengers. When referencing an RPH, the same RPH type is used to identify the assigned unique ID in an element that references the item in a collection. | Note: This is a unique reference ID for one set of payment card information that is set here
     * and may be referenced elsewhere in this message. | Example: 1 | Payment Card Reference ID.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PaymentCardType
     * @uses PaymentCardType::setCardType()
     * @uses PaymentCardType::setIssuer()
     * @uses PaymentCardType::setCardHolderName()
     * @uses PaymentCardType::setCardHolderNameDetails()
     * @uses PaymentCardType::setAddress()
     * @uses PaymentCardType::setTelephone()
     * @uses PaymentCardType::setEmail()
     * @uses PaymentCardType::setCardNumber()
     * @uses PaymentCardType::setSeriesCode()
     * @uses PaymentCardType::setCustLoyalty()
     * @uses PaymentCardType::setMagneticStripe()
     * @uses PaymentCardType::setThreeDomainSecurity()
     * @uses PaymentCardType::setSignatureOnFile()
     * @uses PaymentCardType::setTPA_Extensions()
     * @uses PaymentCardType::setExtendedPaymentInd()
     * @uses PaymentCardType::setSecureInd()
     * @uses PaymentCardType::setSignatureOnFileInd()
     * @uses PaymentCardType::setCardCode()
     * @uses PaymentCardType::setCardHolderRPH()
     * @uses PaymentCardType::setCompanyCardReference()
     * @uses PaymentCardType::setCountryOfIssue()
     * @uses PaymentCardType::setRemark()
     * @uses PaymentCardType::setRPH()
     * @param mixed $cardType
     * @param \StructType\Issuer $issuer
     * @param mixed $cardHolderName
     * @param mixed $cardHolderNameDetails
     * @param mixed $address
     * @param \StructType\Telephone[] $telephone
     * @param mixed[] $email
     * @param mixed $cardNumber
     * @param mixed $seriesCode
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param mixed[] $magneticStripe
     * @param \StructType\ThreeDomainSecurity $threeDomainSecurity
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @param mixed $tPA_Extensions
     * @param bool $extendedPaymentInd
     * @param bool $secureInd
     * @param bool $signatureOnFileInd
     * @param string $cardCode
     * @param string $cardHolderRPH
     * @param string $companyCardReference
     * @param string $countryOfIssue
     * @param string $remark
     * @param string $rPH
     */
    public function __construct($cardType = null, \StructType\Issuer $issuer = null, $cardHolderName = null, $cardHolderNameDetails = null, $address = null, array $telephone = array(), array $email = array(), $cardNumber = null, $seriesCode = null, array $custLoyalty = array(), array $magneticStripe = array(), \StructType\ThreeDomainSecurity $threeDomainSecurity = null, \StructType\SignatureOnFile $signatureOnFile = null, $tPA_Extensions = null, $extendedPaymentInd = null, $secureInd = null, $signatureOnFileInd = null, $cardCode = null, $cardHolderRPH = null, $companyCardReference = null, $countryOfIssue = null, $remark = null, $rPH = null)
    {
        $this
            ->setCardType($cardType)
            ->setIssuer($issuer)
            ->setCardHolderName($cardHolderName)
            ->setCardHolderNameDetails($cardHolderNameDetails)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setCardNumber($cardNumber)
            ->setSeriesCode($seriesCode)
            ->setCustLoyalty($custLoyalty)
            ->setMagneticStripe($magneticStripe)
            ->setThreeDomainSecurity($threeDomainSecurity)
            ->setSignatureOnFile($signatureOnFile)
            ->setTPA_Extensions($tPA_Extensions)
            ->setExtendedPaymentInd($extendedPaymentInd)
            ->setSecureInd($secureInd)
            ->setSignatureOnFileInd($signatureOnFileInd)
            ->setCardCode($cardCode)
            ->setCardHolderRPH($cardHolderRPH)
            ->setCompanyCardReference($companyCardReference)
            ->setCountryOfIssue($countryOfIssue)
            ->setRemark($remark)
            ->setRPH($rPH);
    }
    /**
     * Get CardType value
     * @return mixed|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param mixed $cardType
     * @return \StructType\PaymentCardType
     */
    public function setCardType($cardType = null)
    {
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get Issuer value
     * @return \StructType\Issuer|null
     */
    public function getIssuer()
    {
        return $this->Issuer;
    }
    /**
     * Set Issuer value
     * @param \StructType\Issuer $issuer
     * @return \StructType\PaymentCardType
     */
    public function setIssuer(\StructType\Issuer $issuer = null)
    {
        $this->Issuer = $issuer;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return mixed|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param mixed $cardHolderName
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CardHolderNameDetails value
     * @return mixed|null
     */
    public function getCardHolderNameDetails()
    {
        return $this->CardHolderNameDetails;
    }
    /**
     * Set CardHolderNameDetails value
     * @param mixed $cardHolderNameDetails
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderNameDetails($cardHolderNameDetails = null)
    {
        $this->CardHolderNameDetails = $cardHolderNameDetails;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\PaymentCardType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($paymentCardTypeTelephoneItem) ? get_class($paymentCardTypeTelephoneItem) : sprintf('%s(%s)', gettype($paymentCardTypeTelephoneItem), var_export($paymentCardTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\PaymentCardType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\PaymentCardType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return mixed[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeEmailItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($paymentCardTypeEmailItem) ? get_class($paymentCardTypeEmailItem) : sprintf('%s(%s)', gettype($paymentCardTypeEmailItem), var_export($paymentCardTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param mixed[] $email
     * @return \StructType\PaymentCardType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PaymentCardType
     */
    public function addToEmail($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return mixed|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param mixed $cardNumber
     * @return \StructType\PaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return mixed|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param mixed $seriesCode
     * @return \StructType\PaymentCardType
     */
    public function setSeriesCode($seriesCode = null)
    {
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($paymentCardTypeCustLoyaltyItem) ? get_class($paymentCardTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($paymentCardTypeCustLoyaltyItem), var_export($paymentCardTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\PaymentCardType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\PaymentCardType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get MagneticStripe value
     * @return mixed[]|null
     */
    public function getMagneticStripe()
    {
        return $this->MagneticStripe;
    }
    /**
     * This method is responsible for validating the values passed to the setMagneticStripe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMagneticStripe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMagneticStripeForArrayConstraintsFromSetMagneticStripe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeMagneticStripeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($paymentCardTypeMagneticStripeItem) ? get_class($paymentCardTypeMagneticStripeItem) : sprintf('%s(%s)', gettype($paymentCardTypeMagneticStripeItem), var_export($paymentCardTypeMagneticStripeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MagneticStripe property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MagneticStripe value
     * @throws \InvalidArgumentException
     * @param mixed[] $magneticStripe
     * @return \StructType\PaymentCardType
     */
    public function setMagneticStripe(array $magneticStripe = array())
    {
        // validation for constraint: array
        if ('' !== ($magneticStripeArrayErrorMessage = self::validateMagneticStripeForArrayConstraintsFromSetMagneticStripe($magneticStripe))) {
            throw new \InvalidArgumentException($magneticStripeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($magneticStripe) && count($magneticStripe) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($magneticStripe)), __LINE__);
        }
        $this->MagneticStripe = $magneticStripe;
        return $this;
    }
    /**
     * Add item to MagneticStripe value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PaymentCardType
     */
    public function addToMagneticStripe($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MagneticStripe property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MagneticStripe) && count($this->MagneticStripe) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MagneticStripe)), __LINE__);
        }
        $this->MagneticStripe[] = $item;
        return $this;
    }
    /**
     * Get ThreeDomainSecurity value
     * @return \StructType\ThreeDomainSecurity|null
     */
    public function getThreeDomainSecurity()
    {
        return $this->ThreeDomainSecurity;
    }
    /**
     * Set ThreeDomainSecurity value
     * @param \StructType\ThreeDomainSecurity $threeDomainSecurity
     * @return \StructType\PaymentCardType
     */
    public function setThreeDomainSecurity(\StructType\ThreeDomainSecurity $threeDomainSecurity = null)
    {
        $this->ThreeDomainSecurity = $threeDomainSecurity;
        return $this;
    }
    /**
     * Get SignatureOnFile value
     * @return \StructType\SignatureOnFile|null
     */
    public function getSignatureOnFile()
    {
        return $this->SignatureOnFile;
    }
    /**
     * Set SignatureOnFile value
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFile(\StructType\SignatureOnFile $signatureOnFile = null)
    {
        $this->SignatureOnFile = $signatureOnFile;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\PaymentCardType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ExtendedPaymentInd value
     * @return bool|null
     */
    public function getExtendedPaymentInd()
    {
        return $this->ExtendedPaymentInd;
    }
    /**
     * Set ExtendedPaymentInd value
     * @param bool $extendedPaymentInd
     * @return \StructType\PaymentCardType
     */
    public function setExtendedPaymentInd($extendedPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedPaymentInd) && !is_bool($extendedPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendedPaymentInd, true), gettype($extendedPaymentInd)), __LINE__);
        }
        $this->ExtendedPaymentInd = $extendedPaymentInd;
        return $this;
    }
    /**
     * Get SecureInd value
     * @return bool|null
     */
    public function getSecureInd()
    {
        return $this->SecureInd;
    }
    /**
     * Set SecureInd value
     * @param bool $secureInd
     * @return \StructType\PaymentCardType
     */
    public function setSecureInd($secureInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($secureInd) && !is_bool($secureInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secureInd, true), gettype($secureInd)), __LINE__);
        }
        $this->SecureInd = $secureInd;
        return $this;
    }
    /**
     * Get SignatureOnFileInd value
     * @return bool|null
     */
    public function getSignatureOnFileInd()
    {
        return $this->SignatureOnFileInd;
    }
    /**
     * Set SignatureOnFileInd value
     * @param bool $signatureOnFileInd
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFileInd($signatureOnFileInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureOnFileInd) && !is_bool($signatureOnFileInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureOnFileInd, true), gettype($signatureOnFileInd)), __LINE__);
        }
        $this->SignatureOnFileInd = $signatureOnFileInd;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @uses \EnumType\PaymentCardCodeType::valueIsValid()
     * @uses \EnumType\PaymentCardCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardCode
     * @return \StructType\PaymentCardType
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentCardCodeType::valueIsValid($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentCardCodeType', is_array($cardCode) ? implode(', ', $cardCode) : var_export($cardCode, true), implode(', ', \EnumType\PaymentCardCodeType::getValidValues())), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardHolderRPH value
     * @return string|null
     */
    public function getCardHolderRPH()
    {
        return $this->CardHolderRPH;
    }
    /**
     * Set CardHolderRPH value
     * @param string $cardHolderRPH
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderRPH($cardHolderRPH = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderRPH) && !is_string($cardHolderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderRPH, true), gettype($cardHolderRPH)), __LINE__);
        }
        $this->CardHolderRPH = $cardHolderRPH;
        return $this;
    }
    /**
     * Get CompanyCardReference value
     * @return string|null
     */
    public function getCompanyCardReference()
    {
        return $this->CompanyCardReference;
    }
    /**
     * Set CompanyCardReference value
     * @param string $companyCardReference
     * @return \StructType\PaymentCardType
     */
    public function setCompanyCardReference($companyCardReference = null)
    {
        // validation for constraint: string
        if (!is_null($companyCardReference) && !is_string($companyCardReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCardReference, true), gettype($companyCardReference)), __LINE__);
        }
        $this->CompanyCardReference = $companyCardReference;
        return $this;
    }
    /**
     * Get CountryOfIssue value
     * @return string|null
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param string $countryOfIssue
     * @return \StructType\PaymentCardType
     */
    public function setCountryOfIssue($countryOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssue) && !is_string($countryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfIssue, true), gettype($countryOfIssue)), __LINE__);
        }
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PaymentCardType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PaymentCardType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
