<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParentExtras StructType
 * Meta information extracted from the WSDL
 * - documentation: Selection type and rule code for an extra. | Identifies the parent with which this Extra is available (e.g., an ice skating session with ice skates).
 * @subpackage Structs
 */
class ParentExtras extends AbstractStructBase
{
    /**
     * The ListOfParentRPH
     * Meta information extracted from the WSDL
     * - documentation: Where an option is applicable only to certain passengers, this attribute will contain the ReferencePlaceHolders of the relevant passengers.
     * - use: optional
     * @var list
     */
    public $ListOfParentRPH;
    /**
     * Constructor method for ParentExtras
     * @uses ParentExtras::setListOfParentRPH()
     * @param list $listOfParentRPH
     */
    public function __construct(list $listOfParentRPH = null)
    {
        $this
            ->setListOfParentRPH($listOfParentRPH);
    }
    /**
     * Get ListOfParentRPH value
     * @return list|null
     */
    public function getListOfParentRPH()
    {
        return $this->ListOfParentRPH;
    }
    /**
     * Set ListOfParentRPH value
     * @param list $listOfParentRPH
     * @return \StructType\ParentExtras
     */
    public function setListOfParentRPH(list $listOfParentRPH = null)
    {
        $this->ListOfParentRPH = $listOfParentRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParentExtras
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
