<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * Meta information extracted from the WSDL
 * - documentation: An identifier for the package. | Defines a complete package holiday request.
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: A reference to a source of information for the package.
     * - minOccurs: 0
     * @var mixed
     */
    public $URL;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: The company supplying the package.
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyName;
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The ItineraryItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItineraryItems
     */
    public $ItineraryItems;
    /**
     * The Extras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Extras
     */
    public $Extras;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Package Type (PKG).
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The TravelCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the travel arrangement for the package
     * - use: optional
     * @var mixed
     */
    public $TravelCode;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the accommodation/tour arrangement for a package.
     * - use: optional
     * @var string
     */
    public $TourCode;
    /**
     * The BoardCode
     * Meta information extracted from the WSDL
     * - documentation: The code for a meal plan e.g. AB- as brochure, AI- all inclusive, BB- bed and breakfast, FB- full board, HB- Half Board, RO- room only,SC- self catering
     * - use: optional
     * @var string
     */
    public $BoardCode;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: A code to request a specific promotional price.
     * - use: optional
     * @var string
     */
    public $PromotionCode;
    /**
     * The FreeChildrenQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of free child places required.
     * - use: optional
     * @var int
     */
    public $FreeChildrenQuantity;
    /**
     * The BrandCode
     * Meta information extracted from the WSDL
     * - documentation: The code for the tour operator's product brand (e.g. JMC, Sunset).
     * - use: optional
     * @var string
     */
    public $BrandCode;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - documentation: The tour operator's code for the product within the brand (e.g. Summersun, Greece).
     * - use: optional
     * @var string
     */
    public $ProductCode;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setURL()
     * @uses PackageType::setCompanyName()
     * @uses PackageType::setDateRange()
     * @uses PackageType::setItineraryItems()
     * @uses PackageType::setExtras()
     * @uses PackageType::setType()
     * @uses PackageType::setTravelCode()
     * @uses PackageType::setTourCode()
     * @uses PackageType::setBoardCode()
     * @uses PackageType::setPromotionCode()
     * @uses PackageType::setFreeChildrenQuantity()
     * @uses PackageType::setBrandCode()
     * @uses PackageType::setProductCode()
     * @param mixed $uRL
     * @param mixed $companyName
     * @param \StructType\DateRange $dateRange
     * @param \StructType\ItineraryItems $itineraryItems
     * @param \StructType\Extras $extras
     * @param string $type
     * @param mixed $travelCode
     * @param string $tourCode
     * @param string $boardCode
     * @param string $promotionCode
     * @param int $freeChildrenQuantity
     * @param string $brandCode
     * @param string $productCode
     */
    public function __construct($uRL = null, $companyName = null, \StructType\DateRange $dateRange = null, \StructType\ItineraryItems $itineraryItems = null, \StructType\Extras $extras = null, $type = null, $travelCode = null, $tourCode = null, $boardCode = null, $promotionCode = null, $freeChildrenQuantity = null, $brandCode = null, $productCode = null)
    {
        $this
            ->setURL($uRL)
            ->setCompanyName($companyName)
            ->setDateRange($dateRange)
            ->setItineraryItems($itineraryItems)
            ->setExtras($extras)
            ->setType($type)
            ->setTravelCode($travelCode)
            ->setTourCode($tourCode)
            ->setBoardCode($boardCode)
            ->setPromotionCode($promotionCode)
            ->setFreeChildrenQuantity($freeChildrenQuantity)
            ->setBrandCode($brandCode)
            ->setProductCode($productCode);
    }
    /**
     * Get URL value
     * @return mixed|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param mixed $uRL
     * @return \StructType\PackageType
     */
    public function setURL($uRL = null)
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return mixed|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param mixed $companyName
     * @return \StructType\PackageType
     */
    public function setCompanyName($companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\PackageType
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get ItineraryItems value
     * @return \StructType\ItineraryItems|null
     */
    public function getItineraryItems()
    {
        return $this->ItineraryItems;
    }
    /**
     * Set ItineraryItems value
     * @param \StructType\ItineraryItems $itineraryItems
     * @return \StructType\PackageType
     */
    public function setItineraryItems(\StructType\ItineraryItems $itineraryItems = null)
    {
        $this->ItineraryItems = $itineraryItems;
        return $this;
    }
    /**
     * Get Extras value
     * @return \StructType\Extras|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \StructType\Extras $extras
     * @return \StructType\PackageType
     */
    public function setExtras(\StructType\Extras $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PackageType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return mixed|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param mixed $travelCode
     * @return \StructType\PackageType
     */
    public function setTravelCode($travelCode = null)
    {
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\PackageType
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get BoardCode value
     * @return string|null
     */
    public function getBoardCode()
    {
        return $this->BoardCode;
    }
    /**
     * Set BoardCode value
     * @param string $boardCode
     * @return \StructType\PackageType
     */
    public function setBoardCode($boardCode = null)
    {
        // validation for constraint: string
        if (!is_null($boardCode) && !is_string($boardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boardCode, true), gettype($boardCode)), __LINE__);
        }
        $this->BoardCode = $boardCode;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\PackageType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get FreeChildrenQuantity value
     * @return int|null
     */
    public function getFreeChildrenQuantity()
    {
        return $this->FreeChildrenQuantity;
    }
    /**
     * Set FreeChildrenQuantity value
     * @param int $freeChildrenQuantity
     * @return \StructType\PackageType
     */
    public function setFreeChildrenQuantity($freeChildrenQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($freeChildrenQuantity) && !(is_int($freeChildrenQuantity) || ctype_digit($freeChildrenQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freeChildrenQuantity, true), gettype($freeChildrenQuantity)), __LINE__);
        }
        $this->FreeChildrenQuantity = $freeChildrenQuantity;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\PackageType
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\PackageType
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
