<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTCFareBreakdownType StructType
 * Meta information extracted from the WSDL
 * - documentation: Per passenger type code pricing for this itinerary. Set if fareBreakdown was requested.
 * @subpackage Structs
 */
class PTCFareBreakdownType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of individuals traveling under this PTC.
     * @var mixed
     */
    public $PassengerTypeQuantity;
    /**
     * The FareBasisCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareBasisCodes
     */
    public $FareBasisCodes;
    /**
     * The PassengerFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\PassengerFare[]
     */
    public $PassengerFare;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The TicketDesignators
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TicketDesignators
     */
    public $TicketDesignators;
    /**
     * The Endorsements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Endorsements
     */
    public $Endorsements;
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FareInfo[]
     */
    public $FareInfo;
    /**
     * The PricingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\PricingUnit[]
     */
    public $PricingUnit;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the fare is public, private or both.
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more flights to which this fare applies.
     * - use: optional
     * @var list
     */
    public $FlightRefNumberRPHList;
    /**
     * Constructor method for PTCFareBreakdownType
     * @uses PTCFareBreakdownType::setPassengerTypeQuantity()
     * @uses PTCFareBreakdownType::setFareBasisCodes()
     * @uses PTCFareBreakdownType::setPassengerFare()
     * @uses PTCFareBreakdownType::setTravelerRefNumber()
     * @uses PTCFareBreakdownType::setTicketDesignators()
     * @uses PTCFareBreakdownType::setEndorsements()
     * @uses PTCFareBreakdownType::setFareInfo()
     * @uses PTCFareBreakdownType::setPricingUnit()
     * @uses PTCFareBreakdownType::setPricingSource()
     * @uses PTCFareBreakdownType::setFlightRefNumberRPHList()
     * @param mixed $passengerTypeQuantity
     * @param \StructType\FareBasisCodes $fareBasisCodes
     * @param \StructType\PassengerFare[] $passengerFare
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param \StructType\TicketDesignators $ticketDesignators
     * @param \StructType\Endorsements $endorsements
     * @param \StructType\FareInfo[] $fareInfo
     * @param \StructType\PricingUnit[] $pricingUnit
     * @param string $pricingSource
     * @param list $flightRefNumberRPHList
     */
    public function __construct($passengerTypeQuantity = null, \StructType\FareBasisCodes $fareBasisCodes = null, array $passengerFare = array(), array $travelerRefNumber = array(), \StructType\TicketDesignators $ticketDesignators = null, \StructType\Endorsements $endorsements = null, array $fareInfo = array(), array $pricingUnit = array(), $pricingSource = null, list $flightRefNumberRPHList = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setFareBasisCodes($fareBasisCodes)
            ->setPassengerFare($passengerFare)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setTicketDesignators($ticketDesignators)
            ->setEndorsements($endorsements)
            ->setFareInfo($fareInfo)
            ->setPricingUnit($pricingUnit)
            ->setPricingSource($pricingSource)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return mixed|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param mixed $passengerTypeQuantity
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPassengerTypeQuantity($passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get FareBasisCodes value
     * @return \StructType\FareBasisCodes|null
     */
    public function getFareBasisCodes()
    {
        return $this->FareBasisCodes;
    }
    /**
     * Set FareBasisCodes value
     * @param \StructType\FareBasisCodes $fareBasisCodes
     * @return \StructType\PTCFareBreakdownType
     */
    public function setFareBasisCodes(\StructType\FareBasisCodes $fareBasisCodes = null)
    {
        $this->FareBasisCodes = $fareBasisCodes;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return \StructType\PassengerFare[]|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerFareForArrayConstraintsFromSetPassengerFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTCFareBreakdownTypePassengerFareItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypePassengerFareItem instanceof \StructType\PassengerFare) {
                $invalidValues[] = is_object($pTCFareBreakdownTypePassengerFareItem) ? get_class($pTCFareBreakdownTypePassengerFareItem) : sprintf('%s(%s)', gettype($pTCFareBreakdownTypePassengerFareItem), var_export($pTCFareBreakdownTypePassengerFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerFare property can only contain items of type \StructType\PassengerFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerFare value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerFare[] $passengerFare
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPassengerFare(array $passengerFare = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerFareArrayErrorMessage = self::validatePassengerFareForArrayConstraintsFromSetPassengerFare($passengerFare))) {
            throw new \InvalidArgumentException($passengerFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($passengerFare) && count($passengerFare) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($passengerFare)), __LINE__);
        }
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Add item to PassengerFare value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerFare $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToPassengerFare(\StructType\PassengerFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerFare) {
            throw new \InvalidArgumentException(sprintf('The PassengerFare property can only contain items of type \StructType\PassengerFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->PassengerFare) && count($this->PassengerFare) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->PassengerFare)), __LINE__);
        }
        $this->PassengerFare[] = $item;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTCFareBreakdownTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                $invalidValues[] = is_object($pTCFareBreakdownTypeTravelerRefNumberItem) ? get_class($pTCFareBreakdownTypeTravelerRefNumberItem) : sprintf('%s(%s)', gettype($pTCFareBreakdownTypeTravelerRefNumberItem), var_export($pTCFareBreakdownTypeTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\PTCFareBreakdownType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($travelerRefNumber) && count($travelerRefNumber) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($travelerRefNumber)), __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TravelerRefNumber) && count($this->TravelerRefNumber) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TravelerRefNumber)), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get TicketDesignators value
     * @return \StructType\TicketDesignators|null
     */
    public function getTicketDesignators()
    {
        return $this->TicketDesignators;
    }
    /**
     * Set TicketDesignators value
     * @param \StructType\TicketDesignators $ticketDesignators
     * @return \StructType\PTCFareBreakdownType
     */
    public function setTicketDesignators(\StructType\TicketDesignators $ticketDesignators = null)
    {
        $this->TicketDesignators = $ticketDesignators;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \StructType\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \StructType\Endorsements $endorsements
     * @return \StructType\PTCFareBreakdownType
     */
    public function setEndorsements(\StructType\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFareInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareInfoForArrayConstraintsFromSetFareInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTCFareBreakdownTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeFareInfoItem instanceof \StructType\FareInfo) {
                $invalidValues[] = is_object($pTCFareBreakdownTypeFareInfoItem) ? get_class($pTCFareBreakdownTypeFareInfoItem) : sprintf('%s(%s)', gettype($pTCFareBreakdownTypeFareInfoItem), var_export($pTCFareBreakdownTypeFareInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo[] $fareInfo
     * @return \StructType\PTCFareBreakdownType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($fareInfoArrayErrorMessage = self::validateFareInfoForArrayConstraintsFromSetFareInfo($fareInfo))) {
            throw new \InvalidArgumentException($fareInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareInfo) && count($fareInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareInfo)), __LINE__);
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToFareInfo(\StructType\FareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareInfo) && count($this->FareInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareInfo)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get PricingUnit value
     * @return \StructType\PricingUnit[]|null
     */
    public function getPricingUnit()
    {
        return $this->PricingUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingUnitForArrayConstraintsFromSetPricingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTCFareBreakdownTypePricingUnitItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypePricingUnitItem instanceof \StructType\PricingUnit) {
                $invalidValues[] = is_object($pTCFareBreakdownTypePricingUnitItem) ? get_class($pTCFareBreakdownTypePricingUnitItem) : sprintf('%s(%s)', gettype($pTCFareBreakdownTypePricingUnitItem), var_export($pTCFareBreakdownTypePricingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingUnit property can only contain items of type \StructType\PricingUnit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingUnit[] $pricingUnit
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPricingUnit(array $pricingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingUnitArrayErrorMessage = self::validatePricingUnitForArrayConstraintsFromSetPricingUnit($pricingUnit))) {
            throw new \InvalidArgumentException($pricingUnitArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($pricingUnit) && count($pricingUnit) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($pricingUnit)), __LINE__);
        }
        $this->PricingUnit = $pricingUnit;
        return $this;
    }
    /**
     * Add item to PricingUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingUnit $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToPricingUnit(\StructType\PricingUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingUnit) {
            throw new \InvalidArgumentException(sprintf('The PricingUnit property can only contain items of type \StructType\PricingUnit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->PricingUnit) && count($this->PricingUnit) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->PricingUnit)), __LINE__);
        }
        $this->PricingUnit[] = $item;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \EnumType\PricingSourceType::valueIsValid()
     * @uses \EnumType\PricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingSourceType', is_array($pricingSource) ? implode(', ', $pricingSource) : var_export($pricingSource, true), implode(', ', \EnumType\PricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return list|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param list $flightRefNumberRPHList
     * @return \StructType\PTCFareBreakdownType
     */
    public function setFlightRefNumberRPHList(list $flightRefNumberRPHList = null)
    {
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PTCFareBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
