<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherSrvcPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of data between parties. | Used to indicate a level of preference for a service perference. | Identifies other service preferences.
 * @subpackage Structs
 */
class OtherSrvcPrefType extends AbstractStructBase
{
    /**
     * The OtherSrvcName
     * Meta information extracted from the WSDL
     * - documentation: The name identfiying the service.
     * @var mixed
     */
    public $OtherSrvcName;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a vendor.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $VendorPref;
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a loyalty program.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a form of payment.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentFormPref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a special request.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TravelPurpose
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Travel Purpose (TVP).
     * - use: optional
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for OtherSrvcPrefType
     * @uses OtherSrvcPrefType::setOtherSrvcName()
     * @uses OtherSrvcPrefType::setVendorPref()
     * @uses OtherSrvcPrefType::setLoyaltyPref()
     * @uses OtherSrvcPrefType::setPaymentFormPref()
     * @uses OtherSrvcPrefType::setSpecRequestPref()
     * @uses OtherSrvcPrefType::setTPA_Extensions()
     * @uses OtherSrvcPrefType::setTravelPurpose()
     * @param mixed $otherSrvcName
     * @param mixed[] $vendorPref
     * @param mixed[] $loyaltyPref
     * @param mixed[] $paymentFormPref
     * @param mixed[] $specRequestPref
     * @param mixed $tPA_Extensions
     * @param string $travelPurpose
     */
    public function __construct($otherSrvcName = null, array $vendorPref = array(), array $loyaltyPref = array(), array $paymentFormPref = array(), array $specRequestPref = array(), $tPA_Extensions = null, $travelPurpose = null)
    {
        $this
            ->setOtherSrvcName($otherSrvcName)
            ->setVendorPref($vendorPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get OtherSrvcName value
     * @return mixed|null
     */
    public function getOtherSrvcName()
    {
        return $this->OtherSrvcName;
    }
    /**
     * Set OtherSrvcName value
     * @param mixed $otherSrvcName
     * @return \StructType\OtherSrvcPrefType
     */
    public function setOtherSrvcName($otherSrvcName = null)
    {
        $this->OtherSrvcName = $otherSrvcName;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return mixed[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherSrvcPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($otherSrvcPrefTypeVendorPrefItem) ? get_class($otherSrvcPrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($otherSrvcPrefTypeVendorPrefItem), var_export($otherSrvcPrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $vendorPref
     * @return \StructType\OtherSrvcPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($vendorPref) && count($vendorPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($vendorPref)), __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OtherSrvcPrefType
     */
    public function addToVendorPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->VendorPref) && count($this->VendorPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->VendorPref)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return mixed[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherSrvcPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($otherSrvcPrefTypeLoyaltyPrefItem) ? get_class($otherSrvcPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($otherSrvcPrefTypeLoyaltyPrefItem), var_export($otherSrvcPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyPref
     * @return \StructType\OtherSrvcPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($loyaltyPref) && count($loyaltyPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($loyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OtherSrvcPrefType
     */
    public function addToLoyaltyPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->LoyaltyPref) && count($this->LoyaltyPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->LoyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return mixed[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherSrvcPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($otherSrvcPrefTypePaymentFormPrefItem) ? get_class($otherSrvcPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($otherSrvcPrefTypePaymentFormPrefItem), var_export($otherSrvcPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentFormPref
     * @return \StructType\OtherSrvcPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($paymentFormPref) && count($paymentFormPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($paymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OtherSrvcPrefType
     */
    public function addToPaymentFormPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PaymentFormPref) && count($this->PaymentFormPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PaymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return mixed[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherSrvcPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($otherSrvcPrefTypeSpecRequestPrefItem) ? get_class($otherSrvcPrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($otherSrvcPrefTypeSpecRequestPrefItem), var_export($otherSrvcPrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specRequestPref
     * @return \StructType\OtherSrvcPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specRequestPref) && count($specRequestPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specRequestPref)), __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OtherSrvcPrefType
     */
    public function addToSpecRequestPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecRequestPref) && count($this->SpecRequestPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecRequestPref)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\OtherSrvcPrefType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \StructType\OtherSrvcPrefType
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelPurpose, true), gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherSrvcPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
