<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherHotels StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of other area hotels.
 * @subpackage Structs
 */
class OtherHotels extends AbstractStructBase
{
    /**
     * The OtherHotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\OtherHotel[]
     */
    public $OtherHotel;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when OtherHotels was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for OtherHotels
     * @uses OtherHotels::setOtherHotel()
     * @uses OtherHotels::setLastUpdated()
     * @param \StructType\OtherHotel[] $otherHotel
     * @param string $lastUpdated
     */
    public function __construct(array $otherHotel = array(), $lastUpdated = null)
    {
        $this
            ->setOtherHotel($otherHotel)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get OtherHotel value
     * @return \StructType\OtherHotel[]|null
     */
    public function getOtherHotel()
    {
        return $this->OtherHotel;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherHotelForArrayConstraintsFromSetOtherHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherHotelsOtherHotelItem) {
            // validation for constraint: itemType
            if (!$otherHotelsOtherHotelItem instanceof \StructType\OtherHotel) {
                $invalidValues[] = is_object($otherHotelsOtherHotelItem) ? get_class($otherHotelsOtherHotelItem) : sprintf('%s(%s)', gettype($otherHotelsOtherHotelItem), var_export($otherHotelsOtherHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherHotel property can only contain items of type \StructType\OtherHotel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherHotel value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherHotel[] $otherHotel
     * @return \StructType\OtherHotels
     */
    public function setOtherHotel(array $otherHotel = array())
    {
        // validation for constraint: array
        if ('' !== ($otherHotelArrayErrorMessage = self::validateOtherHotelForArrayConstraintsFromSetOtherHotel($otherHotel))) {
            throw new \InvalidArgumentException($otherHotelArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($otherHotel) && count($otherHotel) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($otherHotel)), __LINE__);
        }
        $this->OtherHotel = $otherHotel;
        return $this;
    }
    /**
     * Add item to OtherHotel value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherHotel $item
     * @return \StructType\OtherHotels
     */
    public function addToOtherHotel(\StructType\OtherHotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherHotel) {
            throw new \InvalidArgumentException(sprintf('The OtherHotel property can only contain items of type \StructType\OtherHotel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OtherHotel) && count($this->OtherHotel) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OtherHotel)), __LINE__);
        }
        $this->OtherHotel[] = $item;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\OtherHotels
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherHotels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
