<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationSummaryType_DEPRECATE StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines summary information about the rail origin and destination.
 * @subpackage Structs
 */
class OriginDestinationSummaryType_DEPRECATE extends AbstractStructBase
{
    /**
     * The OriginLocation
     * @var mixed
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var mixed
     */
    public $DestinationLocation;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The TrainInfo
     * Meta information extracted from the WSDL
     * - documentation: Train info in each train segment.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TrainInfo;
    /**
     * Constructor method for OriginDestinationSummaryType_DEPRECATE
     * @uses OriginDestinationSummaryType_DEPRECATE::setOriginLocation()
     * @uses OriginDestinationSummaryType_DEPRECATE::setDestinationLocation()
     * @uses OriginDestinationSummaryType_DEPRECATE::setDepartureDateTime()
     * @uses OriginDestinationSummaryType_DEPRECATE::setArrivalDateTime()
     * @uses OriginDestinationSummaryType_DEPRECATE::setTrainInfo()
     * @param mixed $originLocation
     * @param mixed $destinationLocation
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param mixed[] $trainInfo
     */
    public function __construct($originLocation = null, $destinationLocation = null, $departureDateTime = null, $arrivalDateTime = null, array $trainInfo = array())
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setTrainInfo($trainInfo);
    }
    /**
     * Get OriginLocation value
     * @return mixed|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param mixed $originLocation
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function setOriginLocation($originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return mixed|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param mixed $destinationLocation
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function setDestinationLocation($destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get TrainInfo value
     * @return mixed[]|null
     */
    public function getTrainInfo()
    {
        return $this->TrainInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTrainInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrainInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrainInfoForArrayConstraintsFromSetTrainInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $originDestinationSummaryType_DEPRECATETrainInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($originDestinationSummaryType_DEPRECATETrainInfoItem) ? get_class($originDestinationSummaryType_DEPRECATETrainInfoItem) : sprintf('%s(%s)', gettype($originDestinationSummaryType_DEPRECATETrainInfoItem), var_export($originDestinationSummaryType_DEPRECATETrainInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrainInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrainInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $trainInfo
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function setTrainInfo(array $trainInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($trainInfoArrayErrorMessage = self::validateTrainInfoForArrayConstraintsFromSetTrainInfo($trainInfo))) {
            throw new \InvalidArgumentException($trainInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($trainInfo) && count($trainInfo) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($trainInfo)), __LINE__);
        }
        $this->TrainInfo = $trainInfo;
        return $this;
    }
    /**
     * Add item to TrainInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public function addToTrainInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TrainInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->TrainInfo) && count($this->TrainInfo) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->TrainInfo)), __LINE__);
        }
        $this->TrainInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationSummaryType_DEPRECATE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
