<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for flight segments.
 * @subpackage Structs
 */
class OriginDestinationOptionType extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 8
     * @var \StructType\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * Constructor method for OriginDestinationOptionType
     * @uses OriginDestinationOptionType::setFlightSegment()
     * @param \StructType\FlightSegment[] $flightSegment
     */
    public function __construct(array $flightSegment = array())
    {
        $this
            ->setFlightSegment($flightSegment);
    }
    /**
     * Get FlightSegment value
     * @return \StructType\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightSegmentForArrayConstraintsFromSetFlightSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $originDestinationOptionTypeFlightSegmentItem) {
            // validation for constraint: itemType
            if (!$originDestinationOptionTypeFlightSegmentItem instanceof \StructType\FlightSegment) {
                $invalidValues[] = is_object($originDestinationOptionTypeFlightSegmentItem) ? get_class($originDestinationOptionTypeFlightSegmentItem) : sprintf('%s(%s)', gettype($originDestinationOptionTypeFlightSegmentItem), var_export($originDestinationOptionTypeFlightSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightSegment property can only contain items of type \StructType\FlightSegment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightSegment[] $flightSegment
     * @return \StructType\OriginDestinationOptionType
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($flightSegmentArrayErrorMessage = self::validateFlightSegmentForArrayConstraintsFromSetFlightSegment($flightSegment))) {
            throw new \InvalidArgumentException($flightSegmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($flightSegment) && count($flightSegment) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 8', count($flightSegment)), __LINE__);
        }
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightSegment $item
     * @return \StructType\OriginDestinationOptionType
     */
    public function addToFlightSegment(\StructType\FlightSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightSegment) {
            throw new \InvalidArgumentException(sprintf('The FlightSegment property can only contain items of type \StructType\FlightSegment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($this->FlightSegment) && count($this->FlightSegment) >= 8) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 8', count($this->FlightSegment)), __LINE__);
        }
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationOptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
