<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOption StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for OriginDestinationOptionType.
 * @subpackage Structs
 */
class OriginDestinationOption extends OriginDestinationOptionType
{
    /**
     * The RefNumber
     * Meta information extracted from the WSDL
     * - documentation: When a PricedItinerary element contains multiple solutions and a single price, this attribute identifies the OriginDestinationPair from the request.
     * - use: optional
     * @var int
     */
    public $RefNumber;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Unique ID for ths origin/ destination pair.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The TravelPurpose
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the purpose, whether for business, personal or other. Refer to OpenTravel Code List Travel Purpose (TVP).
     * - use: optional
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for OriginDestinationOption
     * @uses OriginDestinationOption::setRefNumber()
     * @uses OriginDestinationOption::setRPH()
     * @uses OriginDestinationOption::setTravelPurpose()
     * @param int $refNumber
     * @param string $rPH
     * @param string $travelPurpose
     */
    public function __construct($refNumber = null, $rPH = null, $travelPurpose = null)
    {
        $this
            ->setRefNumber($refNumber)
            ->setRPH($rPH)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get RefNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param int $refNumber
     * @return \StructType\OriginDestinationOption
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !(is_int($refNumber) || ctype_digit($refNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refNumber, true), gettype($refNumber)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\OriginDestinationOption
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \StructType\OriginDestinationOption
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelPurpose, true), gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
