<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestination StructType
 * Meta information extracted from the WSDL
 * - documentation: The true origin and destination. | Origin and Destination location and time information for the trip.
 * @subpackage Structs
 */
class OriginDestination extends OriginDestinationInformationType
{
    /**
     * The AlternateLocationInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlternateLocationInfo
     */
    public $AlternateLocationInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference to this origin destination information.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for OriginDestination
     * @uses OriginDestination::setAlternateLocationInfo()
     * @uses OriginDestination::setTPA_Extensions()
     * @uses OriginDestination::setRPH()
     * @param \StructType\AlternateLocationInfo $alternateLocationInfo
     * @param mixed $tPA_Extensions
     * @param string $rPH
     */
    public function __construct(\StructType\AlternateLocationInfo $alternateLocationInfo = null, $tPA_Extensions = null, $rPH = null)
    {
        $this
            ->setAlternateLocationInfo($alternateLocationInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH);
    }
    /**
     * Get AlternateLocationInfo value
     * @return \StructType\AlternateLocationInfo|null
     */
    public function getAlternateLocationInfo()
    {
        return $this->AlternateLocationInfo;
    }
    /**
     * Set AlternateLocationInfo value
     * @param \StructType\AlternateLocationInfo $alternateLocationInfo
     * @return \StructType\OriginDestination
     */
    public function setAlternateLocationInfo(\StructType\AlternateLocationInfo $alternateLocationInfo = null)
    {
        $this->AlternateLocationInfo = $alternateLocationInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\OriginDestination
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\OriginDestination
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
