<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginAndDestination StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on one specific journey from one specific origin to one specific destination.
 * @subpackage Structs
 */
class OriginAndDestination extends AbstractStructBase
{
    /**
     * The OriginLocation
     * Meta information extracted from the WSDL
     * - documentation: Travel Origin Location - for example, air uses the IATA 3 letter code.
     * @var mixed
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * Meta information extracted from the WSDL
     * - documentation: Travel Destination Location - for example, air uses the IATA 3 letter code.
     * @var mixed
     */
    public $DestinationLocation;
    /**
     * The TrainSegment
     * Meta information extracted from the WSDL
     * - documentation: Full details on one specific train segment, including the origin and destination locations for this segment, equipment used, services offered, etc.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $TrainSegment;
    /**
     * Constructor method for OriginAndDestination
     * @uses OriginAndDestination::setOriginLocation()
     * @uses OriginAndDestination::setDestinationLocation()
     * @uses OriginAndDestination::setTrainSegment()
     * @param mixed $originLocation
     * @param mixed $destinationLocation
     * @param mixed[] $trainSegment
     */
    public function __construct($originLocation = null, $destinationLocation = null, array $trainSegment = array())
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setTrainSegment($trainSegment);
    }
    /**
     * Get OriginLocation value
     * @return mixed|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param mixed $originLocation
     * @return \StructType\OriginAndDestination
     */
    public function setOriginLocation($originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return mixed|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param mixed $destinationLocation
     * @return \StructType\OriginAndDestination
     */
    public function setDestinationLocation($destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get TrainSegment value
     * @return mixed[]|null
     */
    public function getTrainSegment()
    {
        return $this->TrainSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setTrainSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrainSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrainSegmentForArrayConstraintsFromSetTrainSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $originAndDestinationTrainSegmentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($originAndDestinationTrainSegmentItem) ? get_class($originAndDestinationTrainSegmentItem) : sprintf('%s(%s)', gettype($originAndDestinationTrainSegmentItem), var_export($originAndDestinationTrainSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrainSegment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrainSegment value
     * @throws \InvalidArgumentException
     * @param mixed[] $trainSegment
     * @return \StructType\OriginAndDestination
     */
    public function setTrainSegment(array $trainSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($trainSegmentArrayErrorMessage = self::validateTrainSegmentForArrayConstraintsFromSetTrainSegment($trainSegment))) {
            throw new \InvalidArgumentException($trainSegmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($trainSegment) && count($trainSegment) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($trainSegment)), __LINE__);
        }
        $this->TrainSegment = $trainSegment;
        return $this;
    }
    /**
     * Add item to TrainSegment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OriginAndDestination
     */
    public function addToTrainSegment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TrainSegment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->TrainSegment) && count($this->TrainSegment) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->TrainSegment)), __LINE__);
        }
        $this->TrainSegment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginAndDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
