<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the details of one or more orders.
 * @subpackage Structs
 */
class OrdersType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Order[]
     */
    public $Order;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of orders.
     * - use: optional
     * @var string
     */
    public $OrderType;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - documentation: A discount code that applies to the orders.
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The VendorPurchaseOrderID
     * Meta information extracted from the WSDL
     * - documentation: The purchase order number of a sales intermediary.
     * - use: optional
     * @var string
     */
    public $VendorPurchaseOrderID;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: The identification number associated to the orders.
     * - use: optional
     * @var string
     */
    public $OrderID;
    /**
     * Constructor method for OrdersType
     * @uses OrdersType::setOrder()
     * @uses OrdersType::setTPA_Extensions()
     * @uses OrdersType::setOrderType()
     * @uses OrdersType::setDiscountCode()
     * @uses OrdersType::setVendorPurchaseOrderID()
     * @uses OrdersType::setOrderID()
     * @param \StructType\Order[] $order
     * @param mixed $tPA_Extensions
     * @param string $orderType
     * @param string $discountCode
     * @param string $vendorPurchaseOrderID
     * @param string $orderID
     */
    public function __construct(array $order = array(), $tPA_Extensions = null, $orderType = null, $discountCode = null, $vendorPurchaseOrderID = null, $orderID = null)
    {
        $this
            ->setOrder($order)
            ->setTPA_Extensions($tPA_Extensions)
            ->setOrderType($orderType)
            ->setDiscountCode($discountCode)
            ->setVendorPurchaseOrderID($vendorPurchaseOrderID)
            ->setOrderID($orderID);
    }
    /**
     * Get Order value
     * @return \StructType\Order[]|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ordersTypeOrderItem) {
            // validation for constraint: itemType
            if (!$ordersTypeOrderItem instanceof \StructType\Order) {
                $invalidValues[] = is_object($ordersTypeOrderItem) ? get_class($ordersTypeOrderItem) : sprintf('%s(%s)', gettype($ordersTypeOrderItem), var_export($ordersTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\Order, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order[] $order
     * @return \StructType\OrdersType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($order) && count($order) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order $item
     * @return \StructType\OrdersType
     */
    public function addToOrder(\StructType\Order $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\Order, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Order) && count($this->Order) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Order)), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\OrdersType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \StructType\OrdersType
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\OrdersType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get VendorPurchaseOrderID value
     * @return string|null
     */
    public function getVendorPurchaseOrderID()
    {
        return $this->VendorPurchaseOrderID;
    }
    /**
     * Set VendorPurchaseOrderID value
     * @param string $vendorPurchaseOrderID
     * @return \StructType\OrdersType
     */
    public function setVendorPurchaseOrderID($vendorPurchaseOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPurchaseOrderID) && !is_string($vendorPurchaseOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorPurchaseOrderID, true), gettype($vendorPurchaseOrderID)), __LINE__);
        }
        $this->VendorPurchaseOrderID = $vendorPurchaseOrderID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\OrdersType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrdersType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
