<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatorPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Preferred rail operator network code(s).
 * @subpackage Structs
 */
class OperatorPref extends NetworkCodeType
{
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Preferred | Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID (reference place holder) used to identify this rail operator in other elements within this schema.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for OperatorPref
     * @uses OperatorPref::setPreferLevel()
     * @uses OperatorPref::setRPH()
     * @param string $preferLevel
     * @param string $rPH
     */
    public function __construct($preferLevel = null, $rPH = null)
    {
        $this
            ->setPreferLevel($preferLevel)
            ->setRPH($rPH);
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\OperatorPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\OperatorPref
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatorPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
