<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The date range for which the operation schedule information is valid. | Collection of operation schedules.
 * @subpackage Structs
 */
class OperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta information extracted from the WSDL
     * - documentation: The OperationSchedule class defines the dates and hours of operation.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $OperationSchedule;
    /**
     * Constructor method for OperationSchedulesType
     * @uses OperationSchedulesType::setOperationSchedule()
     * @param mixed[] $operationSchedule
     */
    public function __construct(array $operationSchedule = array())
    {
        $this
            ->setOperationSchedule($operationSchedule);
    }
    /**
     * Get OperationSchedule value
     * @return mixed[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationScheduleForArrayConstraintsFromSetOperationSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : sprintf('%s(%s)', gettype($operationSchedulesTypeOperationScheduleItem), var_export($operationSchedulesTypeOperationScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperationSchedule property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param mixed[] $operationSchedule
     * @return \StructType\OperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($operationScheduleArrayErrorMessage = self::validateOperationScheduleForArrayConstraintsFromSetOperationSchedule($operationSchedule))) {
            throw new \InvalidArgumentException($operationScheduleArrayErrorMessage, __LINE__);
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OperationSchedulesType
     */
    public function addToOperationSchedule($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationSchedulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
