<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyWeightType StructType
 * Meta information extracted from the WSDL
 * - documentation: Weight measurement system, unit of measure and weight value with ontology reference.
 * @subpackage Structs
 */
class OntologyWeightType extends AbstractStructBase
{
    /**
     * The MeasurementSystem
     * Meta information extracted from the WSDL
     * - base: List_OfferMeasurementSystem
     * - use: required
     * @var string
     */
    public $MeasurementSystem;
    /**
     * The WeightUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WeightUnit
     */
    public $WeightUnit;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyWeightType
     * @uses OntologyWeightType::setMeasurementSystem()
     * @uses OntologyWeightType::setWeightUnit()
     * @uses OntologyWeightType::setOntologyRefID()
     * @param string $measurementSystem
     * @param \StructType\WeightUnit $weightUnit
     * @param string $ontologyRefID
     */
    public function __construct($measurementSystem = null, \StructType\WeightUnit $weightUnit = null, $ontologyRefID = null)
    {
        $this
            ->setMeasurementSystem($measurementSystem)
            ->setWeightUnit($weightUnit)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get MeasurementSystem value
     * @return string
     */
    public function getMeasurementSystem()
    {
        return $this->MeasurementSystem;
    }
    /**
     * Set MeasurementSystem value
     * @param string $measurementSystem
     * @return \StructType\OntologyWeightType
     */
    public function setMeasurementSystem($measurementSystem = null)
    {
        // validation for constraint: string
        if (!is_null($measurementSystem) && !is_string($measurementSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementSystem, true), gettype($measurementSystem)), __LINE__);
        }
        $this->MeasurementSystem = $measurementSystem;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return \StructType\WeightUnit|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @param \StructType\WeightUnit $weightUnit
     * @return \StructType\OntologyWeightType
     */
    public function setWeightUnit(\StructType\WeightUnit $weightUnit = null)
    {
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyWeightType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyWeightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
