<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyTravelerClassType StructType
 * Meta information extracted from the WSDL
 * - documentation: Traveler classification information with ontology reference.
 * @subpackage Structs
 */
class OntologyTravelerClassType extends AbstractStructBase
{
    /**
     * The AgeCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AgeCategory[]
     */
    public $AgeCategory;
    /**
     * The PassengerCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PassengerCategory[]
     */
    public $PassengerCategory;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The DisabledQty
     * Meta information extracted from the WSDL
     * - documentation: Example: 1 | Total disabled traveler quantity.
     * - use: optional
     * @var int
     */
    public $DisabledQty;
    /**
     * Constructor method for OntologyTravelerClassType
     * @uses OntologyTravelerClassType::setAgeCategory()
     * @uses OntologyTravelerClassType::setPassengerCategory()
     * @uses OntologyTravelerClassType::setOntologyExtension()
     * @uses OntologyTravelerClassType::setDisabledQty()
     * @param \StructType\AgeCategory[] $ageCategory
     * @param \StructType\PassengerCategory[] $passengerCategory
     * @param mixed $ontologyExtension
     * @param int $disabledQty
     */
    public function __construct(array $ageCategory = array(), array $passengerCategory = array(), $ontologyExtension = null, $disabledQty = null)
    {
        $this
            ->setAgeCategory($ageCategory)
            ->setPassengerCategory($passengerCategory)
            ->setOntologyExtension($ontologyExtension)
            ->setDisabledQty($disabledQty);
    }
    /**
     * Get AgeCategory value
     * @return \StructType\AgeCategory[]|null
     */
    public function getAgeCategory()
    {
        return $this->AgeCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setAgeCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgeCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgeCategoryForArrayConstraintsFromSetAgeCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyTravelerClassTypeAgeCategoryItem) {
            // validation for constraint: itemType
            if (!$ontologyTravelerClassTypeAgeCategoryItem instanceof \StructType\AgeCategory) {
                $invalidValues[] = is_object($ontologyTravelerClassTypeAgeCategoryItem) ? get_class($ontologyTravelerClassTypeAgeCategoryItem) : sprintf('%s(%s)', gettype($ontologyTravelerClassTypeAgeCategoryItem), var_export($ontologyTravelerClassTypeAgeCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgeCategory property can only contain items of type \StructType\AgeCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgeCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeCategory[] $ageCategory
     * @return \StructType\OntologyTravelerClassType
     */
    public function setAgeCategory(array $ageCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($ageCategoryArrayErrorMessage = self::validateAgeCategoryForArrayConstraintsFromSetAgeCategory($ageCategory))) {
            throw new \InvalidArgumentException($ageCategoryArrayErrorMessage, __LINE__);
        }
        $this->AgeCategory = $ageCategory;
        return $this;
    }
    /**
     * Add item to AgeCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeCategory $item
     * @return \StructType\OntologyTravelerClassType
     */
    public function addToAgeCategory(\StructType\AgeCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AgeCategory) {
            throw new \InvalidArgumentException(sprintf('The AgeCategory property can only contain items of type \StructType\AgeCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AgeCategory[] = $item;
        return $this;
    }
    /**
     * Get PassengerCategory value
     * @return \StructType\PassengerCategory[]|null
     */
    public function getPassengerCategory()
    {
        return $this->PassengerCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerCategoryForArrayConstraintsFromSetPassengerCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyTravelerClassTypePassengerCategoryItem) {
            // validation for constraint: itemType
            if (!$ontologyTravelerClassTypePassengerCategoryItem instanceof \StructType\PassengerCategory) {
                $invalidValues[] = is_object($ontologyTravelerClassTypePassengerCategoryItem) ? get_class($ontologyTravelerClassTypePassengerCategoryItem) : sprintf('%s(%s)', gettype($ontologyTravelerClassTypePassengerCategoryItem), var_export($ontologyTravelerClassTypePassengerCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerCategory property can only contain items of type \StructType\PassengerCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerCategory[] $passengerCategory
     * @return \StructType\OntologyTravelerClassType
     */
    public function setPassengerCategory(array $passengerCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerCategoryArrayErrorMessage = self::validatePassengerCategoryForArrayConstraintsFromSetPassengerCategory($passengerCategory))) {
            throw new \InvalidArgumentException($passengerCategoryArrayErrorMessage, __LINE__);
        }
        $this->PassengerCategory = $passengerCategory;
        return $this;
    }
    /**
     * Add item to PassengerCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerCategory $item
     * @return \StructType\OntologyTravelerClassType
     */
    public function addToPassengerCategory(\StructType\PassengerCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerCategory) {
            throw new \InvalidArgumentException(sprintf('The PassengerCategory property can only contain items of type \StructType\PassengerCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PassengerCategory[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyTravelerClassType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get DisabledQty value
     * @return int|null
     */
    public function getDisabledQty()
    {
        return $this->DisabledQty;
    }
    /**
     * Set DisabledQty value
     * @param int $disabledQty
     * @return \StructType\OntologyTravelerClassType
     */
    public function setDisabledQty($disabledQty = null)
    {
        // validation for constraint: int
        if (!is_null($disabledQty) && !(is_int($disabledQty) || ctype_digit($disabledQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disabledQty, true), gettype($disabledQty)), __LINE__);
        }
        $this->DisabledQty = $disabledQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyTravelerClassType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
