<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyTransportationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Transportation information with ontology reference.
 * @subpackage Structs
 */
class OntologyTransportationType extends AbstractStructBase
{
    /**
     * The TripDirection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TripDirection
     */
    public $TripDirection;
    /**
     * The FlightAndRail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlightAndRail
     */
    public $FlightAndRail;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vehicle
     */
    public $Vehicle;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyTransportationType
     * @uses OntologyTransportationType::setTripDirection()
     * @uses OntologyTransportationType::setFlightAndRail()
     * @uses OntologyTransportationType::setVehicle()
     * @uses OntologyTransportationType::setOntologyExtension()
     * @param \StructType\TripDirection $tripDirection
     * @param \StructType\FlightAndRail $flightAndRail
     * @param \StructType\Vehicle $vehicle
     * @param mixed $ontologyExtension
     */
    public function __construct(\StructType\TripDirection $tripDirection = null, \StructType\FlightAndRail $flightAndRail = null, \StructType\Vehicle $vehicle = null, $ontologyExtension = null)
    {
        $this
            ->setTripDirection($tripDirection)
            ->setFlightAndRail($flightAndRail)
            ->setVehicle($vehicle)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get TripDirection value
     * @return \StructType\TripDirection|null
     */
    public function getTripDirection()
    {
        return $this->TripDirection;
    }
    /**
     * Set TripDirection value
     * @param \StructType\TripDirection $tripDirection
     * @return \StructType\OntologyTransportationType
     */
    public function setTripDirection(\StructType\TripDirection $tripDirection = null)
    {
        $this->TripDirection = $tripDirection;
        return $this;
    }
    /**
     * Get FlightAndRail value
     * @return \StructType\FlightAndRail|null
     */
    public function getFlightAndRail()
    {
        return $this->FlightAndRail;
    }
    /**
     * Set FlightAndRail value
     * @param \StructType\FlightAndRail $flightAndRail
     * @return \StructType\OntologyTransportationType
     */
    public function setFlightAndRail(\StructType\FlightAndRail $flightAndRail = null)
    {
        $this->FlightAndRail = $flightAndRail;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\Vehicle $vehicle
     * @return \StructType\OntologyTransportationType
     */
    public function setVehicle(\StructType\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyTransportationType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyTransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
