<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyPaymentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment information with ontology reference.
 * @subpackage Structs
 */
class OntologyPaymentType extends AbstractStructBase
{
    /**
     * The TotalTripPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalTripPrice
     */
    public $TotalTripPrice;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Rate
     */
    public $Rate;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentStatus
     */
    public $PaymentStatus;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentMethod
     */
    public $PaymentMethod;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardType
     */
    public $CardType;
    /**
     * The CardIssuer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardIssuer
     */
    public $CardIssuer;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The RewardsInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, a card that accumulates travel rewards was used. | Travel rewards indicator.
     * - use: optional
     * @var bool
     */
    public $RewardsInd;
    /**
     * Constructor method for OntologyPaymentType
     * @uses OntologyPaymentType::setTotalTripPrice()
     * @uses OntologyPaymentType::setRate()
     * @uses OntologyPaymentType::setPaymentStatus()
     * @uses OntologyPaymentType::setPaymentMethod()
     * @uses OntologyPaymentType::setCardType()
     * @uses OntologyPaymentType::setCardIssuer()
     * @uses OntologyPaymentType::setOntologyExtension()
     * @uses OntologyPaymentType::setRewardsInd()
     * @param \StructType\TotalTripPrice $totalTripPrice
     * @param \StructType\Rate $rate
     * @param \StructType\PaymentStatus $paymentStatus
     * @param \StructType\PaymentMethod $paymentMethod
     * @param \StructType\CardType $cardType
     * @param \StructType\CardIssuer $cardIssuer
     * @param mixed $ontologyExtension
     * @param bool $rewardsInd
     */
    public function __construct(\StructType\TotalTripPrice $totalTripPrice = null, \StructType\Rate $rate = null, \StructType\PaymentStatus $paymentStatus = null, \StructType\PaymentMethod $paymentMethod = null, \StructType\CardType $cardType = null, \StructType\CardIssuer $cardIssuer = null, $ontologyExtension = null, $rewardsInd = null)
    {
        $this
            ->setTotalTripPrice($totalTripPrice)
            ->setRate($rate)
            ->setPaymentStatus($paymentStatus)
            ->setPaymentMethod($paymentMethod)
            ->setCardType($cardType)
            ->setCardIssuer($cardIssuer)
            ->setOntologyExtension($ontologyExtension)
            ->setRewardsInd($rewardsInd);
    }
    /**
     * Get TotalTripPrice value
     * @return \StructType\TotalTripPrice|null
     */
    public function getTotalTripPrice()
    {
        return $this->TotalTripPrice;
    }
    /**
     * Set TotalTripPrice value
     * @param \StructType\TotalTripPrice $totalTripPrice
     * @return \StructType\OntologyPaymentType
     */
    public function setTotalTripPrice(\StructType\TotalTripPrice $totalTripPrice = null)
    {
        $this->TotalTripPrice = $totalTripPrice;
        return $this;
    }
    /**
     * Get Rate value
     * @return \StructType\Rate|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param \StructType\Rate $rate
     * @return \StructType\OntologyPaymentType
     */
    public function setRate(\StructType\Rate $rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get PaymentStatus value
     * @return \StructType\PaymentStatus|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @param \StructType\PaymentStatus $paymentStatus
     * @return \StructType\OntologyPaymentType
     */
    public function setPaymentStatus(\StructType\PaymentStatus $paymentStatus = null)
    {
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\PaymentMethod|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\PaymentMethod $paymentMethod
     * @return \StructType\OntologyPaymentType
     */
    public function setPaymentMethod(\StructType\PaymentMethod $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get CardType value
     * @return \StructType\CardType|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param \StructType\CardType $cardType
     * @return \StructType\OntologyPaymentType
     */
    public function setCardType(\StructType\CardType $cardType = null)
    {
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardIssuer value
     * @return \StructType\CardIssuer|null
     */
    public function getCardIssuer()
    {
        return $this->CardIssuer;
    }
    /**
     * Set CardIssuer value
     * @param \StructType\CardIssuer $cardIssuer
     * @return \StructType\OntologyPaymentType
     */
    public function setCardIssuer(\StructType\CardIssuer $cardIssuer = null)
    {
        $this->CardIssuer = $cardIssuer;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyPaymentType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get RewardsInd value
     * @return bool|null
     */
    public function getRewardsInd()
    {
        return $this->RewardsInd;
    }
    /**
     * Set RewardsInd value
     * @param bool $rewardsInd
     * @return \StructType\OntologyPaymentType
     */
    public function setRewardsInd($rewardsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rewardsInd) && !is_bool($rewardsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rewardsInd, true), gettype($rewardsInd)), __LINE__);
        }
        $this->RewardsInd = $rewardsInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyPaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
