<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Location information with ontology reference.
 * @subpackage Structs
 */
class OntologyLocationType extends AbstractStructBase
{
    /**
     * The Type
     * @var \StructType\Type
     */
    public $Type;
    /**
     * The GeneralLocation
     * Meta information extracted from the WSDL
     * - choice: GeneralLocation | Geocode | PhysicalLocation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralLocation
     */
    public $GeneralLocation;
    /**
     * The Geocode
     * Meta information extracted from the WSDL
     * - choice: GeneralLocation | Geocode | PhysicalLocation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Geocode
     */
    public $Geocode;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - choice: GeneralLocation | Geocode | PhysicalLocation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PhysicalLocation
     */
    public $PhysicalLocation;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyLocationType
     * @uses OntologyLocationType::setType()
     * @uses OntologyLocationType::setGeneralLocation()
     * @uses OntologyLocationType::setGeocode()
     * @uses OntologyLocationType::setPhysicalLocation()
     * @uses OntologyLocationType::setOntologyExtension()
     * @param \StructType\Type $type
     * @param \StructType\GeneralLocation $generalLocation
     * @param \StructType\Geocode $geocode
     * @param \StructType\PhysicalLocation $physicalLocation
     * @param mixed $ontologyExtension
     */
    public function __construct(\StructType\Type $type = null, \StructType\GeneralLocation $generalLocation = null, \StructType\Geocode $geocode = null, \StructType\PhysicalLocation $physicalLocation = null, $ontologyExtension = null)
    {
        $this
            ->setType($type)
            ->setGeneralLocation($generalLocation)
            ->setGeocode($geocode)
            ->setPhysicalLocation($physicalLocation)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Type value
     * @return \StructType\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\Type $type
     * @return \StructType\OntologyLocationType
     */
    public function setType(\StructType\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GeneralLocation value
     * @return \StructType\GeneralLocation|null
     */
    public function getGeneralLocation()
    {
        return isset($this->GeneralLocation) ? $this->GeneralLocation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneralLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralLocation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneralLocationForChoiceConstraintsFromSetGeneralLocation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Geocode',
            'PhysicalLocation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GeneralLocation can\'t be set as the property %s is already set. Only one property must be set among these properties: GeneralLocation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GeneralLocation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeneralLocation $generalLocation
     * @return \StructType\OntologyLocationType
     */
    public function setGeneralLocation(\StructType\GeneralLocation $generalLocation = null)
    {
        // validation for constraint: choice(GeneralLocation, Geocode, PhysicalLocation)
        if ('' !== ($generalLocationChoiceErrorMessage = self::validateGeneralLocationForChoiceConstraintsFromSetGeneralLocation($generalLocation))) {
            throw new \InvalidArgumentException($generalLocationChoiceErrorMessage, __LINE__);
        }
        if (is_null($generalLocation) || (is_array($generalLocation) && empty($generalLocation))) {
            unset($this->GeneralLocation);
        } else {
            $this->GeneralLocation = $generalLocation;
        }
        return $this;
    }
    /**
     * Get Geocode value
     * @return \StructType\Geocode|null
     */
    public function getGeocode()
    {
        return isset($this->Geocode) ? $this->Geocode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeocode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeocode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeocodeForChoiceConstraintsFromSetGeocode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GeneralLocation',
            'PhysicalLocation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Geocode can\'t be set as the property %s is already set. Only one property must be set among these properties: Geocode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Geocode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Geocode $geocode
     * @return \StructType\OntologyLocationType
     */
    public function setGeocode(\StructType\Geocode $geocode = null)
    {
        // validation for constraint: choice(GeneralLocation, Geocode, PhysicalLocation)
        if ('' !== ($geocodeChoiceErrorMessage = self::validateGeocodeForChoiceConstraintsFromSetGeocode($geocode))) {
            throw new \InvalidArgumentException($geocodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($geocode) || (is_array($geocode) && empty($geocode))) {
            unset($this->Geocode);
        } else {
            $this->Geocode = $geocode;
        }
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \StructType\PhysicalLocation|null
     */
    public function getPhysicalLocation()
    {
        return isset($this->PhysicalLocation) ? $this->PhysicalLocation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPhysicalLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysicalLocation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePhysicalLocationForChoiceConstraintsFromSetPhysicalLocation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GeneralLocation',
            'Geocode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PhysicalLocation can\'t be set as the property %s is already set. Only one property must be set among these properties: PhysicalLocation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PhysicalLocation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PhysicalLocation $physicalLocation
     * @return \StructType\OntologyLocationType
     */
    public function setPhysicalLocation(\StructType\PhysicalLocation $physicalLocation = null)
    {
        // validation for constraint: choice(GeneralLocation, Geocode, PhysicalLocation)
        if ('' !== ($physicalLocationChoiceErrorMessage = self::validatePhysicalLocationForChoiceConstraintsFromSetPhysicalLocation($physicalLocation))) {
            throw new \InvalidArgumentException($physicalLocationChoiceErrorMessage, __LINE__);
        }
        if (is_null($physicalLocation) || (is_array($physicalLocation) && empty($physicalLocation))) {
            unset($this->PhysicalLocation);
        } else {
            $this->PhysicalLocation = $physicalLocation;
        }
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyLocationType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyLocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
