<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelRatePlanRS StructType
 * Meta information extracted from the WSDL
 * - documentation: This element defines standard attributes that appear on the root element for all OpenTravel Messages. | This message returns information about hotel rate plans that meet the requested criteria.
 * @subpackage Structs
 */
class OTA_HotelRatePlanRS extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - documentation: The presence of the empty Success element explicitly indicates that the request message was successful.
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: Used in conjunction with the Success element to define one or more business errors.
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Offers
     */
    public $Offers;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - documentation: Errors are returned if the request was unable to be processed.
     * - choice: Success | Warnings | RatePlans | Offers | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The MessageContentCode
     * Meta information extracted from the WSDL
     * - documentation: Defines specific content of the message being sent. Refer to OpenTravel Code List TDB. | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $MessageContentCode;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TargetName
     * @var string
     */
    public $TargetName;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_HotelRatePlanRS
     * @uses OTA_HotelRatePlanRS::setSuccess()
     * @uses OTA_HotelRatePlanRS::setWarnings()
     * @uses OTA_HotelRatePlanRS::setRatePlans()
     * @uses OTA_HotelRatePlanRS::setOffers()
     * @uses OTA_HotelRatePlanRS::setTPA_Extensions()
     * @uses OTA_HotelRatePlanRS::setErrors()
     * @uses OTA_HotelRatePlanRS::setMessageContentCode()
     * @uses OTA_HotelRatePlanRS::setEchoToken()
     * @uses OTA_HotelRatePlanRS::setTimeStamp()
     * @uses OTA_HotelRatePlanRS::setTarget()
     * @uses OTA_HotelRatePlanRS::setTargetName()
     * @uses OTA_HotelRatePlanRS::setVersion()
     * @uses OTA_HotelRatePlanRS::setTransactionIdentifier()
     * @uses OTA_HotelRatePlanRS::setSequenceNmbr()
     * @uses OTA_HotelRatePlanRS::setTransactionStatusCode()
     * @uses OTA_HotelRatePlanRS::setRetransmissionIndicator()
     * @uses OTA_HotelRatePlanRS::setCorrelationID()
     * @uses OTA_HotelRatePlanRS::setPrimaryLangID()
     * @uses OTA_HotelRatePlanRS::setAltLangID()
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\Offers $offers
     * @param mixed $tPA_Extensions
     * @param \StructType\ErrorsType $errors
     * @param string $messageContentCode
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $targetName
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(\StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\RatePlans $ratePlans = null, \StructType\Offers $offers = null, $tPA_Extensions = null, \StructType\ErrorsType $errors = null, $messageContentCode = null, $echoToken = null, $timeStamp = null, $target = null, $targetName = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setRatePlans($ratePlans)
            ->setOffers($offers)
            ->setTPA_Extensions($tPA_Extensions)
            ->setErrors($errors)
            ->setMessageContentCode($messageContentCode)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTargetName($targetName)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'RatePlans',
            'Offers',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'RatePlans',
            'Offers',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return isset($this->RatePlans) ? $this->RatePlans : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRatePlans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatePlans method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRatePlansForChoiceConstraintsFromSetRatePlans($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Offers',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RatePlans can\'t be set as the property %s is already set. Only one property must be set among these properties: RatePlans, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RatePlans value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($ratePlansChoiceErrorMessage = self::validateRatePlansForChoiceConstraintsFromSetRatePlans($ratePlans))) {
            throw new \InvalidArgumentException($ratePlansChoiceErrorMessage, __LINE__);
        }
        if (is_null($ratePlans) || (is_array($ratePlans) && empty($ratePlans))) {
            unset($this->RatePlans);
        } else {
            $this->RatePlans = $ratePlans;
        }
        return $this;
    }
    /**
     * Get Offers value
     * @return \StructType\Offers|null
     */
    public function getOffers()
    {
        return isset($this->Offers) ? $this->Offers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOffersForChoiceConstraintsFromSetOffers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'RatePlans',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Offers can\'t be set as the property %s is already set. Only one property must be set among these properties: Offers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Offers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Offers $offers
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setOffers(\StructType\Offers $offers = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($offersChoiceErrorMessage = self::validateOffersForChoiceConstraintsFromSetOffers($offers))) {
            throw new \InvalidArgumentException($offersChoiceErrorMessage, __LINE__);
        }
        if (is_null($offers) || (is_array($offers) && empty($offers))) {
            unset($this->Offers);
        } else {
            $this->Offers = $offers;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return isset($this->TPA_Extensions) ? $this->TPA_Extensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTPA_Extensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTPA_Extensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'RatePlans',
            'Offers',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TPA_Extensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TPA_Extensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TPA_Extensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $tPA_Extensions
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($tPA_ExtensionsChoiceErrorMessage = self::validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($tPA_Extensions))) {
            throw new \InvalidArgumentException($tPA_ExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tPA_Extensions) || (is_array($tPA_Extensions) && empty($tPA_Extensions))) {
            unset($this->TPA_Extensions);
        } else {
            $this->TPA_Extensions = $tPA_Extensions;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'RatePlans',
            'Offers',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Success, Warnings, RatePlans, Offers, TPA_Extensions, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get MessageContentCode value
     * @return string|null
     */
    public function getMessageContentCode()
    {
        return $this->MessageContentCode;
    }
    /**
     * Set MessageContentCode value
     * @param string $messageContentCode
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setMessageContentCode($messageContentCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageContentCode) && !is_string($messageContentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageContentCode, true), gettype($messageContentCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($messageContentCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $messageContentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($messageContentCode, true)), __LINE__);
        }
        $this->MessageContentCode = $messageContentCode;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TargetName value
     * @return string|null
     */
    public function getTargetName()
    {
        return $this->TargetName;
    }
    /**
     * Set TargetName value
     * @param string $targetName
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTargetName($targetName = null)
    {
        // validation for constraint: string
        if (!is_null($targetName) && !is_string($targetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetName, true), gettype($targetName)), __LINE__);
        }
        $this->TargetName = $targetName;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_HotelRatePlanRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
