<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OSI_Pref StructType
 * Meta information extracted from the WSDL
 * - documentation: Other Service Information of the rail operators.
 * @subpackage Structs
 */
class OSI_Pref extends AbstractStructBase
{
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - documentation: The operators to which the OSI applies
     * @var mixed
     */
    public $Operator;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: The OSI text.
     * @var mixed
     */
    public $Text;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A proprietary code used between systems to identify an Other Service Information (OSI) item.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for OSI_Pref
     * @uses OSI_Pref::setTravelerRefNumber()
     * @uses OSI_Pref::setOperator()
     * @uses OSI_Pref::setText()
     * @uses OSI_Pref::setCode()
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param mixed $operator
     * @param mixed $text
     * @param string $code
     */
    public function __construct(array $travelerRefNumber = array(), $operator = null, $text = null, $code = null)
    {
        $this
            ->setTravelerRefNumber($travelerRefNumber)
            ->setOperator($operator)
            ->setText($text)
            ->setCode($code);
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oSI_PrefTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$oSI_PrefTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                $invalidValues[] = is_object($oSI_PrefTravelerRefNumberItem) ? get_class($oSI_PrefTravelerRefNumberItem) : sprintf('%s(%s)', gettype($oSI_PrefTravelerRefNumberItem), var_export($oSI_PrefTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\OSI_Pref
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\OSI_Pref
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Operator value
     * @return mixed|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @param mixed $operator
     * @return \StructType\OSI_Pref
     */
    public function setOperator($operator = null)
    {
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get Text value
     * @return mixed|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param mixed $text
     * @return \StructType\OSI_Pref
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\OSI_Pref
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OSI_Pref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
