<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: A container used to specify a certain set of previous messages.
 * @subpackage Structs
 */
class NotifDetails extends AbstractStructBase
{
    /**
     * The HotelNotifReport
     * Meta information extracted from the WSDL
     * - choice: HotelNotifReport | VehNotifReport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\HotelNotifReport
     */
    public $HotelNotifReport;
    /**
     * The VehNotifReport
     * Meta information extracted from the WSDL
     * - choice: HotelNotifReport | VehNotifReport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\VehNotifReport
     */
    public $VehNotifReport;
    /**
     * Constructor method for NotifDetails
     * @uses NotifDetails::setHotelNotifReport()
     * @uses NotifDetails::setVehNotifReport()
     * @param \StructType\HotelNotifReport $hotelNotifReport
     * @param \StructType\VehNotifReport $vehNotifReport
     */
    public function __construct(\StructType\HotelNotifReport $hotelNotifReport = null, \StructType\VehNotifReport $vehNotifReport = null)
    {
        $this
            ->setHotelNotifReport($hotelNotifReport)
            ->setVehNotifReport($vehNotifReport);
    }
    /**
     * Get HotelNotifReport value
     * @return \StructType\HotelNotifReport|null
     */
    public function getHotelNotifReport()
    {
        return isset($this->HotelNotifReport) ? $this->HotelNotifReport : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelNotifReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelNotifReport method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelNotifReportForChoiceConstraintsFromSetHotelNotifReport($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VehNotifReport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelNotifReport can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelNotifReport, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelNotifReport value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HotelNotifReport $hotelNotifReport
     * @return \StructType\NotifDetails
     */
    public function setHotelNotifReport(\StructType\HotelNotifReport $hotelNotifReport = null)
    {
        // validation for constraint: choice(HotelNotifReport, VehNotifReport)
        if ('' !== ($hotelNotifReportChoiceErrorMessage = self::validateHotelNotifReportForChoiceConstraintsFromSetHotelNotifReport($hotelNotifReport))) {
            throw new \InvalidArgumentException($hotelNotifReportChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelNotifReport) || (is_array($hotelNotifReport) && empty($hotelNotifReport))) {
            unset($this->HotelNotifReport);
        } else {
            $this->HotelNotifReport = $hotelNotifReport;
        }
        return $this;
    }
    /**
     * Get VehNotifReport value
     * @return \StructType\VehNotifReport|null
     */
    public function getVehNotifReport()
    {
        return isset($this->VehNotifReport) ? $this->VehNotifReport : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVehNotifReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehNotifReport method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVehNotifReportForChoiceConstraintsFromSetVehNotifReport($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelNotifReport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VehNotifReport can\'t be set as the property %s is already set. Only one property must be set among these properties: VehNotifReport, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VehNotifReport value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehNotifReport $vehNotifReport
     * @return \StructType\NotifDetails
     */
    public function setVehNotifReport(\StructType\VehNotifReport $vehNotifReport = null)
    {
        // validation for constraint: choice(HotelNotifReport, VehNotifReport)
        if ('' !== ($vehNotifReportChoiceErrorMessage = self::validateVehNotifReportForChoiceConstraintsFromSetVehNotifReport($vehNotifReport))) {
            throw new \InvalidArgumentException($vehNotifReportChoiceErrorMessage, __LINE__);
        }
        if (is_null($vehNotifReport) || (is_array($vehNotifReport) && empty($vehNotifReport))) {
            unset($this->VehNotifReport);
        } else {
            $this->VehNotifReport = $vehNotifReport;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
