<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedFareCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains code information for a negotiated fare. | Contains negotiated fare code information.
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class NegotiatedFareCode extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: The ticket designator code for this negotiated fare code.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The OverrideRuleInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the rules for the negotiated fare should not be applied.
     * - use: optional
     * @var bool
     */
    public $OverrideRuleInd;
    /**
     * Constructor method for NegotiatedFareCode
     * @uses NegotiatedFareCode::set_()
     * @uses NegotiatedFareCode::setTicketDesignatorCode()
     * @uses NegotiatedFareCode::setOverrideRuleInd()
     * @param string $_
     * @param string $ticketDesignatorCode
     * @param bool $overrideRuleInd
     */
    public function __construct($_ = null, $ticketDesignatorCode = null, $overrideRuleInd = null)
    {
        $this
            ->set_($_)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setOverrideRuleInd($overrideRuleInd);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\NegotiatedFareCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\NegotiatedFareCode
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get OverrideRuleInd value
     * @return bool|null
     */
    public function getOverrideRuleInd()
    {
        return $this->OverrideRuleInd;
    }
    /**
     * Set OverrideRuleInd value
     * @param bool $overrideRuleInd
     * @return \StructType\NegotiatedFareCode
     */
    public function setOverrideRuleInd($overrideRuleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRuleInd) && !is_bool($overrideRuleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideRuleInd, true), gettype($overrideRuleInd)), __LINE__);
        }
        $this->OverrideRuleInd = $overrideRuleInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NegotiatedFareCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
