<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiModalOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Traveler and trip information used for targeted multi-modal offers.
 * @subpackage Structs
 */
class MultiModalOfferType extends AbstractStructBase
{
    /**
     * The RequestingParty
     * @var \StructType\RequestingParty
     */
    public $RequestingParty;
    /**
     * The Ontology
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Ontology
     */
    public $Ontology;
    /**
     * The RequestedOffer
     * @var \StructType\RequestedOffer
     */
    public $RequestedOffer;
    /**
     * The TripCharacteristics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TripCharacteristics
     */
    public $TripCharacteristics;
    /**
     * The TravelerCharacteristics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TravelerCharacteristics
     */
    public $TravelerCharacteristics;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for MultiModalOfferType
     * @uses MultiModalOfferType::setRequestingParty()
     * @uses MultiModalOfferType::setOntology()
     * @uses MultiModalOfferType::setRequestedOffer()
     * @uses MultiModalOfferType::setTripCharacteristics()
     * @uses MultiModalOfferType::setTravelerCharacteristics()
     * @uses MultiModalOfferType::setOntologyExtension()
     * @param \StructType\RequestingParty $requestingParty
     * @param \StructType\Ontology $ontology
     * @param \StructType\RequestedOffer $requestedOffer
     * @param \StructType\TripCharacteristics $tripCharacteristics
     * @param \StructType\TravelerCharacteristics $travelerCharacteristics
     * @param mixed $ontologyExtension
     */
    public function __construct(\StructType\RequestingParty $requestingParty = null, \StructType\Ontology $ontology = null, \StructType\RequestedOffer $requestedOffer = null, \StructType\TripCharacteristics $tripCharacteristics = null, \StructType\TravelerCharacteristics $travelerCharacteristics = null, $ontologyExtension = null)
    {
        $this
            ->setRequestingParty($requestingParty)
            ->setOntology($ontology)
            ->setRequestedOffer($requestedOffer)
            ->setTripCharacteristics($tripCharacteristics)
            ->setTravelerCharacteristics($travelerCharacteristics)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get RequestingParty value
     * @return \StructType\RequestingParty|null
     */
    public function getRequestingParty()
    {
        return $this->RequestingParty;
    }
    /**
     * Set RequestingParty value
     * @param \StructType\RequestingParty $requestingParty
     * @return \StructType\MultiModalOfferType
     */
    public function setRequestingParty(\StructType\RequestingParty $requestingParty = null)
    {
        $this->RequestingParty = $requestingParty;
        return $this;
    }
    /**
     * Get Ontology value
     * @return \StructType\Ontology|null
     */
    public function getOntology()
    {
        return $this->Ontology;
    }
    /**
     * Set Ontology value
     * @param \StructType\Ontology $ontology
     * @return \StructType\MultiModalOfferType
     */
    public function setOntology(\StructType\Ontology $ontology = null)
    {
        $this->Ontology = $ontology;
        return $this;
    }
    /**
     * Get RequestedOffer value
     * @return \StructType\RequestedOffer|null
     */
    public function getRequestedOffer()
    {
        return $this->RequestedOffer;
    }
    /**
     * Set RequestedOffer value
     * @param \StructType\RequestedOffer $requestedOffer
     * @return \StructType\MultiModalOfferType
     */
    public function setRequestedOffer(\StructType\RequestedOffer $requestedOffer = null)
    {
        $this->RequestedOffer = $requestedOffer;
        return $this;
    }
    /**
     * Get TripCharacteristics value
     * @return \StructType\TripCharacteristics|null
     */
    public function getTripCharacteristics()
    {
        return $this->TripCharacteristics;
    }
    /**
     * Set TripCharacteristics value
     * @param \StructType\TripCharacteristics $tripCharacteristics
     * @return \StructType\MultiModalOfferType
     */
    public function setTripCharacteristics(\StructType\TripCharacteristics $tripCharacteristics = null)
    {
        $this->TripCharacteristics = $tripCharacteristics;
        return $this;
    }
    /**
     * Get TravelerCharacteristics value
     * @return \StructType\TravelerCharacteristics|null
     */
    public function getTravelerCharacteristics()
    {
        return $this->TravelerCharacteristics;
    }
    /**
     * Set TravelerCharacteristics value
     * @param \StructType\TravelerCharacteristics $travelerCharacteristics
     * @return \StructType\MultiModalOfferType
     */
    public function setTravelerCharacteristics(\StructType\TravelerCharacteristics $travelerCharacteristics = null)
    {
        $this->TravelerCharacteristics = $travelerCharacteristics;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\MultiModalOfferType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultiModalOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
