<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscellaneousCharges StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on additional miscellaneous charges that may apply to the rental.
 * @subpackage Structs
 */
class MiscellaneousCharges extends AbstractStructBase
{
    /**
     * The MiscellaneousCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\MiscellaneousCharge[]
     */
    public $MiscellaneousCharge;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: General information about the additional miscellaneous charges that may apply.
     * - minOccurs: 0
     * @var mixed
     */
    public $Info;
    /**
     * Constructor method for MiscellaneousCharges
     * @uses MiscellaneousCharges::setMiscellaneousCharge()
     * @uses MiscellaneousCharges::setInfo()
     * @param \StructType\MiscellaneousCharge[] $miscellaneousCharge
     * @param mixed $info
     */
    public function __construct(array $miscellaneousCharge = array(), $info = null)
    {
        $this
            ->setMiscellaneousCharge($miscellaneousCharge)
            ->setInfo($info);
    }
    /**
     * Get MiscellaneousCharge value
     * @return \StructType\MiscellaneousCharge[]|null
     */
    public function getMiscellaneousCharge()
    {
        return $this->MiscellaneousCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setMiscellaneousCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiscellaneousCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiscellaneousChargeForArrayConstraintsFromSetMiscellaneousCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $miscellaneousChargesMiscellaneousChargeItem) {
            // validation for constraint: itemType
            if (!$miscellaneousChargesMiscellaneousChargeItem instanceof \StructType\MiscellaneousCharge) {
                $invalidValues[] = is_object($miscellaneousChargesMiscellaneousChargeItem) ? get_class($miscellaneousChargesMiscellaneousChargeItem) : sprintf('%s(%s)', gettype($miscellaneousChargesMiscellaneousChargeItem), var_export($miscellaneousChargesMiscellaneousChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiscellaneousCharge property can only contain items of type \StructType\MiscellaneousCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiscellaneousCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\MiscellaneousCharge[] $miscellaneousCharge
     * @return \StructType\MiscellaneousCharges
     */
    public function setMiscellaneousCharge(array $miscellaneousCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($miscellaneousChargeArrayErrorMessage = self::validateMiscellaneousChargeForArrayConstraintsFromSetMiscellaneousCharge($miscellaneousCharge))) {
            throw new \InvalidArgumentException($miscellaneousChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($miscellaneousCharge) && count($miscellaneousCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($miscellaneousCharge)), __LINE__);
        }
        $this->MiscellaneousCharge = $miscellaneousCharge;
        return $this;
    }
    /**
     * Add item to MiscellaneousCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\MiscellaneousCharge $item
     * @return \StructType\MiscellaneousCharges
     */
    public function addToMiscellaneousCharge(\StructType\MiscellaneousCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MiscellaneousCharge) {
            throw new \InvalidArgumentException(sprintf('The MiscellaneousCharge property can only contain items of type \StructType\MiscellaneousCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->MiscellaneousCharge) && count($this->MiscellaneousCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->MiscellaneousCharge)), __LINE__);
        }
        $this->MiscellaneousCharge[] = $item;
        return $this;
    }
    /**
     * Get Info value
     * @return mixed|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param mixed $info
     * @return \StructType\MiscellaneousCharges
     */
    public function setInfo($info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MiscellaneousCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
