<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MembershipType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Membership objects. Memberships provides a list of reward programs which may be credited with points accrued from the guest's activity. Which memberships are to be applied to which part is determined by each object's
 * SelectedMembershipRPHs collection.
 * @subpackage Structs
 */
class MembershipType extends AbstractStructBase
{
    /**
     * The Membership
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Membership[]
     */
    public $Membership;
    /**
     * Constructor method for MembershipType
     * @uses MembershipType::setMembership()
     * @param \StructType\Membership[] $membership
     */
    public function __construct(array $membership = array())
    {
        $this
            ->setMembership($membership);
    }
    /**
     * Get Membership value
     * @return \StructType\Membership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * This method is responsible for validating the values passed to the setMembership method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembership method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMembershipForArrayConstraintsFromSetMembership(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $membershipTypeMembershipItem) {
            // validation for constraint: itemType
            if (!$membershipTypeMembershipItem instanceof \StructType\Membership) {
                $invalidValues[] = is_object($membershipTypeMembershipItem) ? get_class($membershipTypeMembershipItem) : sprintf('%s(%s)', gettype($membershipTypeMembershipItem), var_export($membershipTypeMembershipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership[] $membership
     * @return \StructType\MembershipType
     */
    public function setMembership(array $membership = array())
    {
        // validation for constraint: array
        if ('' !== ($membershipArrayErrorMessage = self::validateMembershipForArrayConstraintsFromSetMembership($membership))) {
            throw new \InvalidArgumentException($membershipArrayErrorMessage, __LINE__);
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership $item
     * @return \StructType\MembershipType
     */
    public function addToMembership(\StructType\Membership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Membership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MembershipType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
