<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership StructType
 * Meta information extracted from the WSDL
 * - documentation: The SelectedMembership object identifies the frequent customer reward program and (optionally) indicates points awarded for stay activity. | The golfer's membership information for this reservation. | To request a reservation record
 * based on golf course membership(s).
 * @subpackage Structs
 */
class Membership extends AbstractStructBase
{
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: The code or name of the membership program ('Hertz', 'AAdvantage', etc.).
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The BonusCode
     * Meta information extracted from the WSDL
     * - documentation: The code or name of the bonus program. BonusCode can be used to indicate the level of membership (Gold Club, Platinum member, etc.)
     * - use: optional
     * @var string
     */
    public $BonusCode;
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - documentation: The account identification number for this particular member in this particular program.
     * - use: optional
     * @var string
     */
    public $AccountID;
    /**
     * The PointsEarned
     * Meta information extracted from the WSDL
     * - documentation: The total number of points earned through the selected membership.
     * - use: optional
     * @var int
     */
    public $PointsEarned;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Identifies the travel sector. Refer to OpenTravel Code List Travel Sector (TVS).
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The PrimaryLoyaltyIndicator
     * @var bool
     */
    public $PrimaryLoyaltyIndicator;
    /**
     * The AllianceLoyaltyLevelName
     * @var string
     */
    public $AllianceLoyaltyLevelName;
    /**
     * The CustomerType
     * @var string
     */
    public $CustomerType;
    /**
     * The CustomerValue
     * @var string
     */
    public $CustomerValue;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The LoyalLevel
     * @var string
     */
    public $LoyalLevel;
    /**
     * The LoyalLevelCode
     * @var string
     */
    public $LoyalLevelCode;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * The SignupDate
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for Membership
     * @uses Membership::setProgramCode()
     * @uses Membership::setBonusCode()
     * @uses Membership::setAccountID()
     * @uses Membership::setPointsEarned()
     * @uses Membership::setTravelSector()
     * @uses Membership::setShareSynchInd()
     * @uses Membership::setShareMarketInd()
     * @uses Membership::setProgramID()
     * @uses Membership::setMembershipID()
     * @uses Membership::setVendorCode()
     * @uses Membership::setPrimaryLoyaltyIndicator()
     * @uses Membership::setAllianceLoyaltyLevelName()
     * @uses Membership::setCustomerType()
     * @uses Membership::setCustomerValue()
     * @uses Membership::setPassword()
     * @uses Membership::setLoyalLevel()
     * @uses Membership::setLoyalLevelCode()
     * @uses Membership::setSingleVendorInd()
     * @uses Membership::setSignupDate()
     * @uses Membership::setEffectiveDate()
     * @uses Membership::setExpireDate()
     * @uses Membership::setExpireDateExclusiveIndicator()
     * @uses Membership::setRPH()
     * @param string $programCode
     * @param string $bonusCode
     * @param string $accountID
     * @param int $pointsEarned
     * @param string $travelSector
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $programID
     * @param string $membershipID
     * @param string $vendorCode
     * @param bool $primaryLoyaltyIndicator
     * @param string $allianceLoyaltyLevelName
     * @param string $customerType
     * @param string $customerValue
     * @param string $password
     * @param string $loyalLevel
     * @param string $loyalLevelCode
     * @param string $singleVendorInd
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $rPH
     */
    public function __construct($programCode = null, $bonusCode = null, $accountID = null, $pointsEarned = null, $travelSector = null, $shareSynchInd = null, $shareMarketInd = null, $programID = null, $membershipID = null, $vendorCode = null, $primaryLoyaltyIndicator = null, $allianceLoyaltyLevelName = null, $customerType = null, $customerValue = null, $password = null, $loyalLevel = null, $loyalLevelCode = null, $singleVendorInd = null, $signupDate = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $rPH = null)
    {
        $this
            ->setProgramCode($programCode)
            ->setBonusCode($bonusCode)
            ->setAccountID($accountID)
            ->setPointsEarned($pointsEarned)
            ->setTravelSector($travelSector)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setVendorCode($vendorCode)
            ->setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator)
            ->setAllianceLoyaltyLevelName($allianceLoyaltyLevelName)
            ->setCustomerType($customerType)
            ->setCustomerValue($customerValue)
            ->setPassword($password)
            ->setLoyalLevel($loyalLevel)
            ->setLoyalLevelCode($loyalLevelCode)
            ->setSingleVendorInd($singleVendorInd)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRPH($rPH);
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\Membership
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get BonusCode value
     * @return string|null
     */
    public function getBonusCode()
    {
        return $this->BonusCode;
    }
    /**
     * Set BonusCode value
     * @param string $bonusCode
     * @return \StructType\Membership
     */
    public function setBonusCode($bonusCode = null)
    {
        // validation for constraint: string
        if (!is_null($bonusCode) && !is_string($bonusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bonusCode, true), gettype($bonusCode)), __LINE__);
        }
        $this->BonusCode = $bonusCode;
        return $this;
    }
    /**
     * Get AccountID value
     * @return string|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \StructType\Membership
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PointsEarned value
     * @return int|null
     */
    public function getPointsEarned()
    {
        return $this->PointsEarned;
    }
    /**
     * Set PointsEarned value
     * @param int $pointsEarned
     * @return \StructType\Membership
     */
    public function setPointsEarned($pointsEarned = null)
    {
        // validation for constraint: int
        if (!is_null($pointsEarned) && !(is_int($pointsEarned) || ctype_digit($pointsEarned))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pointsEarned, true), gettype($pointsEarned)), __LINE__);
        }
        $this->PointsEarned = $pointsEarned;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\Membership
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\Membership
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\Membership
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\Membership
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\Membership
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\Membership
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get PrimaryLoyaltyIndicator value
     * @return bool|null
     */
    public function getPrimaryLoyaltyIndicator()
    {
        return $this->PrimaryLoyaltyIndicator;
    }
    /**
     * Set PrimaryLoyaltyIndicator value
     * @param bool $primaryLoyaltyIndicator
     * @return \StructType\Membership
     */
    public function setPrimaryLoyaltyIndicator($primaryLoyaltyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryLoyaltyIndicator) && !is_bool($primaryLoyaltyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryLoyaltyIndicator, true), gettype($primaryLoyaltyIndicator)), __LINE__);
        }
        $this->PrimaryLoyaltyIndicator = $primaryLoyaltyIndicator;
        return $this;
    }
    /**
     * Get AllianceLoyaltyLevelName value
     * @return string|null
     */
    public function getAllianceLoyaltyLevelName()
    {
        return $this->AllianceLoyaltyLevelName;
    }
    /**
     * Set AllianceLoyaltyLevelName value
     * @param string $allianceLoyaltyLevelName
     * @return \StructType\Membership
     */
    public function setAllianceLoyaltyLevelName($allianceLoyaltyLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceLoyaltyLevelName) && !is_string($allianceLoyaltyLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceLoyaltyLevelName, true), gettype($allianceLoyaltyLevelName)), __LINE__);
        }
        $this->AllianceLoyaltyLevelName = $allianceLoyaltyLevelName;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \StructType\Membership
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\Membership
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Membership
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \StructType\Membership
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevel) && !is_string($loyalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevel, true), gettype($loyalLevel)), __LINE__);
        }
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get LoyalLevelCode value
     * @return string|null
     */
    public function getLoyalLevelCode()
    {
        return $this->LoyalLevelCode;
    }
    /**
     * Set LoyalLevelCode value
     * @param string $loyalLevelCode
     * @return \StructType\Membership
     */
    public function setLoyalLevelCode($loyalLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevelCode) && !is_string($loyalLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevelCode, true), gettype($loyalLevelCode)), __LINE__);
        }
        $this->LoyalLevelCode = $loyalLevelCode;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \StructType\Membership
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        // validation for constraint: string
        if (!is_null($singleVendorInd) && !is_string($singleVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleVendorInd, true), gettype($singleVendorInd)), __LINE__);
        }
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\Membership
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Membership
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Membership
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Membership
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Membership
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Membership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
