<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealPlanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of meal arrangements, booked or available according to context, with appropriate supplementary charges.
 * @subpackage Structs
 */
class MealPlanType extends AbstractStructBase
{
    /**
     * The CustomerCounts
     * Meta information extracted from the WSDL
     * - documentation: Counts of the number of passengers in age categories. Used when individual passenger identification is not required.
     * - minOccurs: 0
     * @var mixed
     */
    public $CustomerCounts;
    /**
     * The PassengerRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PassengerRPHs
     */
    public $PassengerRPHs;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Prices
     */
    public $Prices;
    /**
     * The ListOfRoomRPH
     * Meta information extracted from the WSDL
     * - documentation: A list of the Rooms with which this Meal Plan is available.
     * - use: optional
     * @var list
     */
    public $ListOfRoomRPH;
    /**
     * Constructor method for MealPlanType
     * @uses MealPlanType::setCustomerCounts()
     * @uses MealPlanType::setPassengerRPHs()
     * @uses MealPlanType::setPrices()
     * @uses MealPlanType::setListOfRoomRPH()
     * @param mixed $customerCounts
     * @param \StructType\PassengerRPHs $passengerRPHs
     * @param \StructType\Prices $prices
     * @param list $listOfRoomRPH
     */
    public function __construct($customerCounts = null, \StructType\PassengerRPHs $passengerRPHs = null, \StructType\Prices $prices = null, list $listOfRoomRPH = null)
    {
        $this
            ->setCustomerCounts($customerCounts)
            ->setPassengerRPHs($passengerRPHs)
            ->setPrices($prices)
            ->setListOfRoomRPH($listOfRoomRPH);
    }
    /**
     * Get CustomerCounts value
     * @return mixed|null
     */
    public function getCustomerCounts()
    {
        return $this->CustomerCounts;
    }
    /**
     * Set CustomerCounts value
     * @param mixed $customerCounts
     * @return \StructType\MealPlanType
     */
    public function setCustomerCounts($customerCounts = null)
    {
        $this->CustomerCounts = $customerCounts;
        return $this;
    }
    /**
     * Get PassengerRPHs value
     * @return \StructType\PassengerRPHs|null
     */
    public function getPassengerRPHs()
    {
        return $this->PassengerRPHs;
    }
    /**
     * Set PassengerRPHs value
     * @param \StructType\PassengerRPHs $passengerRPHs
     * @return \StructType\MealPlanType
     */
    public function setPassengerRPHs(\StructType\PassengerRPHs $passengerRPHs = null)
    {
        $this->PassengerRPHs = $passengerRPHs;
        return $this;
    }
    /**
     * Get Prices value
     * @return \StructType\Prices|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \StructType\Prices $prices
     * @return \StructType\MealPlanType
     */
    public function setPrices(\StructType\Prices $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get ListOfRoomRPH value
     * @return list|null
     */
    public function getListOfRoomRPH()
    {
        return $this->ListOfRoomRPH;
    }
    /**
     * Set ListOfRoomRPH value
     * @param list $listOfRoomRPH
     * @return \StructType\MealPlanType
     */
    public function setListOfRoomRPH(list $listOfRoomRPH = null)
    {
        $this->ListOfRoomRPH = $listOfRoomRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealPlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
