<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealPlan StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to search for hotels that offer types of meal plan, such as "all-inclusive". This matches against the static property content, not the meal included in the rate.
 * @subpackage Structs
 */
class MealPlan extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Meal Plan Type (MPT).
     * @var list
     */
    public $Code;
    /**
     * Constructor method for MealPlan
     * @uses MealPlan::setCode()
     * @param list $code
     */
    public function __construct(list $code = null)
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * @return list|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param list $code
     * @return \StructType\MealPlan
     */
    public function setCode(list $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
