<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapURL StructType
 * Meta information extracted from the WSDL
 * - documentation: When requested, a link to a map is returned in the response which indicates the position of the matching hotel(s).
 * @subpackage Structs
 */
class MapURL extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The BottomRightLatitude
     * Meta information extracted from the WSDL
     * - documentation: The bottom right latitude coordinate.
     * @var float
     */
    public $BottomRightLatitude;
    /**
     * The BottomRightLongitude
     * Meta information extracted from the WSDL
     * - documentation: The bottom right longitude coordinate.
     * @var float
     */
    public $BottomRightLongitude;
    /**
     * The TopLeftLatitude
     * Meta information extracted from the WSDL
     * - documentation: The top left latitude coordinate.
     * @var float
     */
    public $TopLeftLatitude;
    /**
     * The TopLeftLongitude
     * Meta information extracted from the WSDL
     * - documentation: The top left longitude coordinate.
     * @var float
     */
    public $TopLeftLongitude;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 999 inclusive.
     * - base: Numeric1to999
     * - maxInclusive: 480
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $Height;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 999 inclusive.
     * - base: Numeric1to999
     * - maxInclusive: 640
     * - minInclusive: 1
     * @var int
     */
    public $Width;
    /**
     * The ZoomFactor
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 0 to 99 inclusive.
     * - base: Numeric0to99
     * - maxInclusive: 12
     * - minInclusive: 0
     * @var int
     */
    public $ZoomFactor;
    /**
     * Constructor method for MapURL
     * @uses MapURL::set_()
     * @uses MapURL::setBottomRightLatitude()
     * @uses MapURL::setBottomRightLongitude()
     * @uses MapURL::setTopLeftLatitude()
     * @uses MapURL::setTopLeftLongitude()
     * @uses MapURL::setHeight()
     * @uses MapURL::setWidth()
     * @uses MapURL::setZoomFactor()
     * @param string $_
     * @param float $bottomRightLatitude
     * @param float $bottomRightLongitude
     * @param float $topLeftLatitude
     * @param float $topLeftLongitude
     * @param int $height
     * @param int $width
     * @param int $zoomFactor
     */
    public function __construct($_ = null, $bottomRightLatitude = null, $bottomRightLongitude = null, $topLeftLatitude = null, $topLeftLongitude = null, $height = null, $width = null, $zoomFactor = null)
    {
        $this
            ->set_($_)
            ->setBottomRightLatitude($bottomRightLatitude)
            ->setBottomRightLongitude($bottomRightLongitude)
            ->setTopLeftLatitude($topLeftLatitude)
            ->setTopLeftLongitude($topLeftLongitude)
            ->setHeight($height)
            ->setWidth($width)
            ->setZoomFactor($zoomFactor);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\MapURL
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get BottomRightLatitude value
     * @return float|null
     */
    public function getBottomRightLatitude()
    {
        return $this->BottomRightLatitude;
    }
    /**
     * Set BottomRightLatitude value
     * @param float $bottomRightLatitude
     * @return \StructType\MapURL
     */
    public function setBottomRightLatitude($bottomRightLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($bottomRightLatitude) && !(is_float($bottomRightLatitude) || is_numeric($bottomRightLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bottomRightLatitude, true), gettype($bottomRightLatitude)), __LINE__);
        }
        $this->BottomRightLatitude = $bottomRightLatitude;
        return $this;
    }
    /**
     * Get BottomRightLongitude value
     * @return float|null
     */
    public function getBottomRightLongitude()
    {
        return $this->BottomRightLongitude;
    }
    /**
     * Set BottomRightLongitude value
     * @param float $bottomRightLongitude
     * @return \StructType\MapURL
     */
    public function setBottomRightLongitude($bottomRightLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($bottomRightLongitude) && !(is_float($bottomRightLongitude) || is_numeric($bottomRightLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bottomRightLongitude, true), gettype($bottomRightLongitude)), __LINE__);
        }
        $this->BottomRightLongitude = $bottomRightLongitude;
        return $this;
    }
    /**
     * Get TopLeftLatitude value
     * @return float|null
     */
    public function getTopLeftLatitude()
    {
        return $this->TopLeftLatitude;
    }
    /**
     * Set TopLeftLatitude value
     * @param float $topLeftLatitude
     * @return \StructType\MapURL
     */
    public function setTopLeftLatitude($topLeftLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($topLeftLatitude) && !(is_float($topLeftLatitude) || is_numeric($topLeftLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($topLeftLatitude, true), gettype($topLeftLatitude)), __LINE__);
        }
        $this->TopLeftLatitude = $topLeftLatitude;
        return $this;
    }
    /**
     * Get TopLeftLongitude value
     * @return float|null
     */
    public function getTopLeftLongitude()
    {
        return $this->TopLeftLongitude;
    }
    /**
     * Set TopLeftLongitude value
     * @param float $topLeftLongitude
     * @return \StructType\MapURL
     */
    public function setTopLeftLongitude($topLeftLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($topLeftLongitude) && !(is_float($topLeftLongitude) || is_numeric($topLeftLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($topLeftLongitude, true), gettype($topLeftLongitude)), __LINE__);
        }
        $this->TopLeftLongitude = $topLeftLongitude;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\MapURL
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: maxInclusive(480)
        if (!is_null($height) && $height > 480) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 480', var_export($height, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($height) && $height < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($height, true)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\MapURL
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: maxInclusive(640)
        if (!is_null($width) && $width > 640) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 640', var_export($width, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($width) && $width < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($width, true)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get ZoomFactor value
     * @return int|null
     */
    public function getZoomFactor()
    {
        return $this->ZoomFactor;
    }
    /**
     * Set ZoomFactor value
     * @param int $zoomFactor
     * @return \StructType\MapURL
     */
    public function setZoomFactor($zoomFactor = null)
    {
        // validation for constraint: int
        if (!is_null($zoomFactor) && !(is_int($zoomFactor) || ctype_digit($zoomFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoomFactor, true), gettype($zoomFactor)), __LINE__);
        }
        // validation for constraint: maxInclusive(12)
        if (!is_null($zoomFactor) && $zoomFactor > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 12', var_export($zoomFactor, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($zoomFactor) && $zoomFactor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($zoomFactor, true)), __LINE__);
        }
        $this->ZoomFactor = $zoomFactor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapURL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
