<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LuggageItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a description and estimated value for a specific piece of luggage/equipment for which the traveler would like additional insurance.
 * @subpackage Structs
 */
class LuggageItem extends AbstractStructBase
{
    /**
     * The LuggageDescription
     * Meta information extracted from the WSDL
     * - documentation: A detailed description of what the piece of luggage/equipment contains.
     * @var mixed
     */
    public $LuggageDescription;
    /**
     * The ItemDeclaredValue
     * @var \StructType\ItemDeclaredValue
     */
    public $ItemDeclaredValue;
    /**
     * The LuggagePremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LuggagePremium
     */
    public $LuggagePremium;
    /**
     * The LuggageType
     * Meta information extracted from the WSDL
     * - documentation: Category to describe the type of luggage e.g. Scuba, camera, computer.
     * @var string
     */
    public $LuggageType;
    /**
     * Constructor method for LuggageItem
     * @uses LuggageItem::setLuggageDescription()
     * @uses LuggageItem::setItemDeclaredValue()
     * @uses LuggageItem::setLuggagePremium()
     * @uses LuggageItem::setLuggageType()
     * @param mixed $luggageDescription
     * @param \StructType\ItemDeclaredValue $itemDeclaredValue
     * @param \StructType\LuggagePremium $luggagePremium
     * @param string $luggageType
     */
    public function __construct($luggageDescription = null, \StructType\ItemDeclaredValue $itemDeclaredValue = null, \StructType\LuggagePremium $luggagePremium = null, $luggageType = null)
    {
        $this
            ->setLuggageDescription($luggageDescription)
            ->setItemDeclaredValue($itemDeclaredValue)
            ->setLuggagePremium($luggagePremium)
            ->setLuggageType($luggageType);
    }
    /**
     * Get LuggageDescription value
     * @return mixed|null
     */
    public function getLuggageDescription()
    {
        return $this->LuggageDescription;
    }
    /**
     * Set LuggageDescription value
     * @param mixed $luggageDescription
     * @return \StructType\LuggageItem
     */
    public function setLuggageDescription($luggageDescription = null)
    {
        $this->LuggageDescription = $luggageDescription;
        return $this;
    }
    /**
     * Get ItemDeclaredValue value
     * @return \StructType\ItemDeclaredValue|null
     */
    public function getItemDeclaredValue()
    {
        return $this->ItemDeclaredValue;
    }
    /**
     * Set ItemDeclaredValue value
     * @param \StructType\ItemDeclaredValue $itemDeclaredValue
     * @return \StructType\LuggageItem
     */
    public function setItemDeclaredValue(\StructType\ItemDeclaredValue $itemDeclaredValue = null)
    {
        $this->ItemDeclaredValue = $itemDeclaredValue;
        return $this;
    }
    /**
     * Get LuggagePremium value
     * @return \StructType\LuggagePremium|null
     */
    public function getLuggagePremium()
    {
        return $this->LuggagePremium;
    }
    /**
     * Set LuggagePremium value
     * @param \StructType\LuggagePremium $luggagePremium
     * @return \StructType\LuggageItem
     */
    public function setLuggagePremium(\StructType\LuggagePremium $luggagePremium = null)
    {
        $this->LuggagePremium = $luggagePremium;
        return $this;
    }
    /**
     * Get LuggageType value
     * @return string|null
     */
    public function getLuggageType()
    {
        return $this->LuggageType;
    }
    /**
     * Set LuggageType value
     * @param string $luggageType
     * @return \StructType\LuggageItem
     */
    public function setLuggageType($luggageType = null)
    {
        // validation for constraint: string
        if (!is_null($luggageType) && !is_string($luggageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($luggageType, true), gettype($luggageType)), __LINE__);
        }
        $this->LuggageType = $luggageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LuggageItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
