<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedBooking StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies cross references at the booking level.
 * @subpackage Structs
 */
class LinkedBooking extends RelatedTravelerType
{
    /**
     * The LinkTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the nature of the link (e.g. booking, dining, tour, back to back). Refer to OpenTravel Code Table Link Type Code (LTC).
     * - use: optional
     * @var list
     */
    public $LinkTypeCode;
    /**
     * Constructor method for LinkedBooking
     * @uses LinkedBooking::setLinkTypeCode()
     * @param list $linkTypeCode
     */
    public function __construct(list $linkTypeCode = null)
    {
        $this
            ->setLinkTypeCode($linkTypeCode);
    }
    /**
     * Get LinkTypeCode value
     * @return list|null
     */
    public function getLinkTypeCode()
    {
        return $this->LinkTypeCode;
    }
    /**
     * Set LinkTypeCode value
     * @param list $linkTypeCode
     * @return \StructType\LinkedBooking
     */
    public function setLinkTypeCode(list $linkTypeCode = null)
    {
        $this->LinkTypeCode = $linkTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinkedBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
