<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary StructType
 * Meta information extracted from the WSDL
 * - documentation: Full details on the itinerary referenced by this reservation. An itinerary represents all inventory booked and associated with this specific reservation.
 * @subpackage Structs
 */
class Itinerary extends AbstractStructBase
{
    /**
     * The OriginAndDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\OriginAndDestination[]
     */
    public $OriginAndDestination;
    /**
     * The RailCharges
     * Meta information extracted from the WSDL
     * - documentation: Information on the individual charges that incurred are a result of this specific itinerary.
     * - minOccurs: 0
     * @var mixed
     */
    public $RailCharges;
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - documentation: A collection of special comments associated with the itinerary.
     * - minOccurs: 0
     * @var mixed
     */
    public $VendorMessages;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setOriginAndDestination()
     * @uses Itinerary::setRailCharges()
     * @uses Itinerary::setVendorMessages()
     * @param \StructType\OriginAndDestination[] $originAndDestination
     * @param mixed $railCharges
     * @param mixed $vendorMessages
     */
    public function __construct(array $originAndDestination = array(), $railCharges = null, $vendorMessages = null)
    {
        $this
            ->setOriginAndDestination($originAndDestination)
            ->setRailCharges($railCharges)
            ->setVendorMessages($vendorMessages);
    }
    /**
     * Get OriginAndDestination value
     * @return \StructType\OriginAndDestination[]|null
     */
    public function getOriginAndDestination()
    {
        return $this->OriginAndDestination;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginAndDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginAndDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginAndDestinationForArrayConstraintsFromSetOriginAndDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itineraryOriginAndDestinationItem) {
            // validation for constraint: itemType
            if (!$itineraryOriginAndDestinationItem instanceof \StructType\OriginAndDestination) {
                $invalidValues[] = is_object($itineraryOriginAndDestinationItem) ? get_class($itineraryOriginAndDestinationItem) : sprintf('%s(%s)', gettype($itineraryOriginAndDestinationItem), var_export($itineraryOriginAndDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginAndDestination property can only contain items of type \StructType\OriginAndDestination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginAndDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginAndDestination[] $originAndDestination
     * @return \StructType\Itinerary
     */
    public function setOriginAndDestination(array $originAndDestination = array())
    {
        // validation for constraint: array
        if ('' !== ($originAndDestinationArrayErrorMessage = self::validateOriginAndDestinationForArrayConstraintsFromSetOriginAndDestination($originAndDestination))) {
            throw new \InvalidArgumentException($originAndDestinationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($originAndDestination) && count($originAndDestination) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($originAndDestination)), __LINE__);
        }
        $this->OriginAndDestination = $originAndDestination;
        return $this;
    }
    /**
     * Add item to OriginAndDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginAndDestination $item
     * @return \StructType\Itinerary
     */
    public function addToOriginAndDestination(\StructType\OriginAndDestination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginAndDestination) {
            throw new \InvalidArgumentException(sprintf('The OriginAndDestination property can only contain items of type \StructType\OriginAndDestination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->OriginAndDestination) && count($this->OriginAndDestination) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->OriginAndDestination)), __LINE__);
        }
        $this->OriginAndDestination[] = $item;
        return $this;
    }
    /**
     * Get RailCharges value
     * @return mixed|null
     */
    public function getRailCharges()
    {
        return $this->RailCharges;
    }
    /**
     * Set RailCharges value
     * @param mixed $railCharges
     * @return \StructType\Itinerary
     */
    public function setRailCharges($railCharges = null)
    {
        $this->RailCharges = $railCharges;
        return $this;
    }
    /**
     * Get VendorMessages value
     * @return mixed|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param mixed $vendorMessages
     * @return \StructType\Itinerary
     */
    public function setVendorMessages($vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
