<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inventories StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of inventory.
 * @subpackage Structs
 */
class Inventories extends AbstractStructBase
{
    /**
     * The Inventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\Inventory[]
     */
    public $Inventory;
    /**
     * Constructor method for Inventories
     * @uses Inventories::setInventory()
     * @param \StructType\Inventory[] $inventory
     */
    public function __construct(array $inventory = array())
    {
        $this
            ->setInventory($inventory);
    }
    /**
     * Get Inventory value
     * @return \StructType\Inventory[]|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * This method is responsible for validating the values passed to the setInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryForArrayConstraintsFromSetInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoriesInventoryItem) {
            // validation for constraint: itemType
            if (!$inventoriesInventoryItem instanceof \StructType\Inventory) {
                $invalidValues[] = is_object($inventoriesInventoryItem) ? get_class($inventoriesInventoryItem) : sprintf('%s(%s)', gettype($inventoriesInventoryItem), var_export($inventoriesInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inventory property can only contain items of type \StructType\Inventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory[] $inventory
     * @return \StructType\Inventories
     */
    public function setInventory(array $inventory = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryArrayErrorMessage = self::validateInventoryForArrayConstraintsFromSetInventory($inventory))) {
            throw new \InvalidArgumentException($inventoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($inventory) && count($inventory) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($inventory)), __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Add item to Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory $item
     * @return \StructType\Inventories
     */
    public function addToInventory(\StructType\Inventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Inventory) {
            throw new \InvalidArgumentException(sprintf('The Inventory property can only contain items of type \StructType\Inventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Inventory) && count($this->Inventory) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Inventory)), __LINE__);
        }
        $this->Inventory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Inventories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
