<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockRoomType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the date range to which rooms are assigned to the inventory block. | Used to define the room types and all of their supporting data within a room block.
 * @subpackage Structs
 */
class InvBlockRoomType extends AbstractStructBase
{
    /**
     * The RoomTypeAllocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\RoomTypeAllocations[]
     */
    public $RoomTypeAllocations;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The DaysOfWeeks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaysOfWeeks
     */
    public $DaysOfWeeks;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code (e.g. GENR, CONC, SUIT).
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for InvBlockRoomType
     * @uses InvBlockRoomType::setRoomTypeAllocations()
     * @uses InvBlockRoomType::setRatePlans()
     * @uses InvBlockRoomType::setDaysOfWeeks()
     * @uses InvBlockRoomType::setRoomTypeCode()
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @param string $roomTypeCode
     */
    public function __construct(array $roomTypeAllocations = array(), \StructType\RatePlans $ratePlans = null, \StructType\DaysOfWeeks $daysOfWeeks = null, $roomTypeCode = null)
    {
        $this
            ->setRoomTypeAllocations($roomTypeAllocations)
            ->setRatePlans($ratePlans)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get RoomTypeAllocations value
     * @return \StructType\RoomTypeAllocations[]|null
     */
    public function getRoomTypeAllocations()
    {
        return $this->RoomTypeAllocations;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomTypeAllocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomTypeAllocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockRoomTypeRoomTypeAllocationsItem) {
            // validation for constraint: itemType
            if (!$invBlockRoomTypeRoomTypeAllocationsItem instanceof \StructType\RoomTypeAllocations) {
                $invalidValues[] = is_object($invBlockRoomTypeRoomTypeAllocationsItem) ? get_class($invBlockRoomTypeRoomTypeAllocationsItem) : sprintf('%s(%s)', gettype($invBlockRoomTypeRoomTypeAllocationsItem), var_export($invBlockRoomTypeRoomTypeAllocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeAllocations(array $roomTypeAllocations = array())
    {
        // validation for constraint: array
        if ('' !== ($roomTypeAllocationsArrayErrorMessage = self::validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations($roomTypeAllocations))) {
            throw new \InvalidArgumentException($roomTypeAllocationsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($roomTypeAllocations) && count($roomTypeAllocations) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($roomTypeAllocations)), __LINE__);
        }
        $this->RoomTypeAllocations = $roomTypeAllocations;
        return $this;
    }
    /**
     * Add item to RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations $item
     * @return \StructType\InvBlockRoomType
     */
    public function addToRoomTypeAllocations(\StructType\RoomTypeAllocations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomTypeAllocations) {
            throw new \InvalidArgumentException(sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->RoomTypeAllocations) && count($this->RoomTypeAllocations) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->RoomTypeAllocations)), __LINE__);
        }
        $this->RoomTypeAllocations[] = $item;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\InvBlockRoomType
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \StructType\DaysOfWeeks|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @return \StructType\InvBlockRoomType
     */
    public function setDaysOfWeeks(\StructType\DaysOfWeeks $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
