<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoCode StructType
 * Meta information extracted from the WSDL
 * - documentation: May be used to give further detail on the code or to remove an obsolete item. | Indicates the generic type of restaurant such as fast food, cafe, fine dining, etc.
 * @subpackage Structs
 */
class InfoCode extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - use: optional
     * @var mixed
     */
    public $Name;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Restaurant Category (RES).
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for InfoCode
     * @uses InfoCode::setName()
     * @uses InfoCode::setCode()
     * @param mixed $name
     * @param string $code
     */
    public function __construct($name = null, $code = null)
    {
        $this
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get Name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param mixed $name
     * @return \StructType\InfoCode
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\InfoCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
