<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelResRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a request message for creating a reservation. It is used by HotelResRQ and HotelResNotifRQ to keep them synchronized.
 * @subpackage Structs
 */
class HotelResRequestType extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: The point-of-sale data, contained in the POS element, communicates the information that allows the receiving system to identify the trading partner that is sending the request or the response message.
     * - minOccurs: 0
     * @var mixed
     */
    public $POS;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $UniqueID;
    /**
     * The HotelReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $HotelReservations;
    /**
     * The ResStatus
     * Meta information extracted from the WSDL
     * - documentation: Indicates the status of the reservation represented by the message.
     * - use: optional
     * @var string
     */
    public $ResStatus;
    /**
     * The HoldDuration
     * Meta information extracted from the WSDL
     * - documentation: The period from the date and time the reservation was booked until the hold on the inventory is released.
     * - use: optional
     * @var string
     */
    public $HoldDuration;
    /**
     * Constructor method for HotelResRequestType
     * @uses HotelResRequestType::setPOS()
     * @uses HotelResRequestType::setUniqueID()
     * @uses HotelResRequestType::setHotelReservations()
     * @uses HotelResRequestType::setResStatus()
     * @uses HotelResRequestType::setHoldDuration()
     * @param mixed $pOS
     * @param mixed[] $uniqueID
     * @param mixed $hotelReservations
     * @param string $resStatus
     * @param string $holdDuration
     */
    public function __construct($pOS = null, array $uniqueID = array(), $hotelReservations = null, $resStatus = null, $holdDuration = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setHotelReservations($hotelReservations)
            ->setResStatus($resStatus)
            ->setHoldDuration($holdDuration);
    }
    /**
     * Get POS value
     * @return mixed|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param mixed $pOS
     * @return \StructType\HotelResRequestType
     */
    public function setPOS($pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return mixed[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelResRequestTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelResRequestTypeUniqueIDItem) ? get_class($hotelResRequestTypeUniqueIDItem) : sprintf('%s(%s)', gettype($hotelResRequestTypeUniqueIDItem), var_export($hotelResRequestTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param mixed[] $uniqueID
     * @return \StructType\HotelResRequestType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($uniqueID) && count($uniqueID) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelResRequestType
     */
    public function addToUniqueID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->UniqueID) && count($this->UniqueID) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->UniqueID)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get HotelReservations value
     * @return mixed|null
     */
    public function getHotelReservations()
    {
        return $this->HotelReservations;
    }
    /**
     * Set HotelReservations value
     * @param mixed $hotelReservations
     * @return \StructType\HotelResRequestType
     */
    public function setHotelReservations($hotelReservations = null)
    {
        $this->HotelReservations = $hotelReservations;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \EnumType\TransactionActionType::valueIsValid()
     * @uses \EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \StructType\HotelResRequestType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($resStatus) ? implode(', ', $resStatus) : var_export($resStatus, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get HoldDuration value
     * @return string|null
     */
    public function getHoldDuration()
    {
        return $this->HoldDuration;
    }
    /**
     * Set HoldDuration value
     * @param string $holdDuration
     * @return \StructType\HotelResRequestType
     */
    public function setHoldDuration($holdDuration = null)
    {
        // validation for constraint: string
        if (!is_null($holdDuration) && !is_string($holdDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdDuration, true), gettype($holdDuration)), __LINE__);
        }
        $this->HoldDuration = $holdDuration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelResRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
