<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRefs StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of hotel identifiers to which the rate plan applies.
 * @subpackage Structs
 */
class HotelRefs extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HotelRef[]
     */
    public $HotelRef;
    /**
     * Constructor method for HotelRefs
     * @uses HotelRefs::setHotelRef()
     * @param \StructType\HotelRef[] $hotelRef
     */
    public function __construct(array $hotelRef = array())
    {
        $this
            ->setHotelRef($hotelRef);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRefForArrayConstraintsFromSetHotelRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelRefsHotelRefItem) {
            // validation for constraint: itemType
            if (!$hotelRefsHotelRefItem instanceof \StructType\HotelRef) {
                $invalidValues[] = is_object($hotelRefsHotelRefItem) ? get_class($hotelRefsHotelRefItem) : sprintf('%s(%s)', gettype($hotelRefsHotelRefItem), var_export($hotelRefsHotelRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef[] $hotelRef
     * @return \StructType\HotelRefs
     */
    public function setHotelRef(array $hotelRef = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRefArrayErrorMessage = self::validateHotelRefForArrayConstraintsFromSetHotelRef($hotelRef))) {
            throw new \InvalidArgumentException($hotelRefArrayErrorMessage, __LINE__);
        }
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef $item
     * @return \StructType\HotelRefs
     */
    public function addToHotelRef(\StructType\HotelRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRef) {
            throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
