<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The hotel name, hotel code, and city code for the hotel booked in a reservation. | To retrieve a hotel reservation when the booking reference is not known.
 * @subpackage Structs
 */
class HotelReadRequest extends AbstractStructBase
{
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: City name eg. Dublin | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The Airport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Airport
     */
    public $Airport;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserID
     */
    public $UserID;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - documentation: This is to be used for verification that the record being sent is the specific record requested.
     * - minOccurs: 0
     * @var \StructType\VerificationType
     */
    public $Verification;
    /**
     * The SelectionCriteria
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectionCriteria[]
     */
    public $SelectionCriteria;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * The TTIcode
     * @var int
     */
    public $TTIcode;
    /**
     * Constructor method for HotelReadRequest
     * @uses HotelReadRequest::setCityName()
     * @uses HotelReadRequest::setAirport()
     * @uses HotelReadRequest::setUserID()
     * @uses HotelReadRequest::setVerification()
     * @uses HotelReadRequest::setSelectionCriteria()
     * @uses HotelReadRequest::setTPA_Extensions()
     * @uses HotelReadRequest::setChainCode()
     * @uses HotelReadRequest::setBrandCode()
     * @uses HotelReadRequest::setHotelCode()
     * @uses HotelReadRequest::setHotelCityCode()
     * @uses HotelReadRequest::setHotelName()
     * @uses HotelReadRequest::setHotelCodeContext()
     * @uses HotelReadRequest::setChainName()
     * @uses HotelReadRequest::setBrandName()
     * @uses HotelReadRequest::setAreaID()
     * @uses HotelReadRequest::setTTIcode()
     * @param string $cityName
     * @param \StructType\Airport $airport
     * @param \StructType\UserID $userID
     * @param \StructType\VerificationType $verification
     * @param \StructType\SelectionCriteria[] $selectionCriteria
     * @param mixed $tPA_Extensions
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     * @param int $tTIcode
     */
    public function __construct($cityName = null, \StructType\Airport $airport = null, \StructType\UserID $userID = null, \StructType\VerificationType $verification = null, array $selectionCriteria = array(), $tPA_Extensions = null, $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null, $tTIcode = null)
    {
        $this
            ->setCityName($cityName)
            ->setAirport($airport)
            ->setUserID($userID)
            ->setVerification($verification)
            ->setSelectionCriteria($selectionCriteria)
            ->setTPA_Extensions($tPA_Extensions)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID)
            ->setTTIcode($tTIcode);
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\HotelReadRequest
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cityName) && mb_strlen($cityName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($cityName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cityName) && mb_strlen($cityName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get Airport value
     * @return \StructType\Airport|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * Set Airport value
     * @param \StructType\Airport $airport
     * @return \StructType\HotelReadRequest
     */
    public function setAirport(\StructType\Airport $airport = null)
    {
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Get UserID value
     * @return \StructType\UserID|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param \StructType\UserID $userID
     * @return \StructType\HotelReadRequest
     */
    public function setUserID(\StructType\UserID $userID = null)
    {
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Verification value
     * @return \StructType\VerificationType|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \StructType\VerificationType $verification
     * @return \StructType\HotelReadRequest
     */
    public function setVerification(\StructType\VerificationType $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get SelectionCriteria value
     * @return \StructType\SelectionCriteria[]|null
     */
    public function getSelectionCriteria()
    {
        return $this->SelectionCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionCriteriaForArrayConstraintsFromSetSelectionCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReadRequestSelectionCriteriaItem) {
            // validation for constraint: itemType
            if (!$hotelReadRequestSelectionCriteriaItem instanceof \StructType\SelectionCriteria) {
                $invalidValues[] = is_object($hotelReadRequestSelectionCriteriaItem) ? get_class($hotelReadRequestSelectionCriteriaItem) : sprintf('%s(%s)', gettype($hotelReadRequestSelectionCriteriaItem), var_export($hotelReadRequestSelectionCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionCriteria property can only contain items of type \StructType\SelectionCriteria, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionCriteria[] $selectionCriteria
     * @return \StructType\HotelReadRequest
     */
    public function setSelectionCriteria(array $selectionCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionCriteriaArrayErrorMessage = self::validateSelectionCriteriaForArrayConstraintsFromSetSelectionCriteria($selectionCriteria))) {
            throw new \InvalidArgumentException($selectionCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SelectionCriteria = $selectionCriteria;
        return $this;
    }
    /**
     * Add item to SelectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionCriteria $item
     * @return \StructType\HotelReadRequest
     */
    public function addToSelectionCriteria(\StructType\SelectionCriteria $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectionCriteria) {
            throw new \InvalidArgumentException(sprintf('The SelectionCriteria property can only contain items of type \StructType\SelectionCriteria, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionCriteria[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\HotelReadRequest
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\HotelReadRequest
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\HotelReadRequest
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelReadRequest
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\HotelReadRequest
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelReadRequest
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\HotelReadRequest
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\HotelReadRequest
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\HotelReadRequest
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\HotelReadRequest
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get TTIcode value
     * @return int|null
     */
    public function getTTIcode()
    {
        return $this->TTIcode;
    }
    /**
     * Set TTIcode value
     * @param int $tTIcode
     * @return \StructType\HotelReadRequest
     */
    public function setTTIcode($tTIcode = null)
    {
        // validation for constraint: int
        if (!is_null($tTIcode) && !(is_int($tTIcode) || ctype_digit($tTIcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tTIcode, true), gettype($tTIcode)), __LINE__);
        }
        $this->TTIcode = $tTIcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
